<?php
/**
 * LayerManager Widget class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     LayerManager Popup Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * Control the communication beetween the layercontrol popup
 * dialog and the main application.
 *
 */
class LayerManager extends CWCWidget
{
    var $moButton;
    var $moPopup;

    /**
     * Constructor of Layer control
     *
     * @return
     */
    function LayerManager()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The LayerManager widget is a complex dialog box that allows the user to
manage the layers in the current context and add new layers from a
list of cached WMS servers.
EOT;

        $this->moButton = new CWCButton($this);

        $this->moPopup = new CWCPopup($this);
        $this->moPopup->mszLink = "widgets/LayerManager.phtml";
        $this->moPopup->mszParam = "&szCallbackFunc=LayerManagerCB";
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick("clickLayerManager");
    }
    
    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }
    
    /**
     * Build and return the array of functions needed in the widget
     *
     * @return array of javascript function
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        $szJsFunctionName = "clickLayerManager";
        $szFunction = "function $szJsFunctionName()\n" .
                      "{\n".
                       $this->moPopup->DrawPublish()."\n".
                      "return;\n" .
                      "}\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "LayerManagerCB";
        $szFunction = <<<EOF

function {$szJsFunctionName}(actionID, wh)
{
    if (actionID == 0 || actionID == 1)
    {
        {$this->mszHTMLForm}.currentState.value = wh.document.forms[0].gszCurrentState.value;

        if (actionID == 0)
          wh.close();

        {$this->mszHTMLForm}.submit();
    }

    return;
}
EOF;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * Return HTML hidden variables.
     *
     * @return array of javascript hidden variables
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        $szVariable = "currentState";
        $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * Return the HTML code to display the link to the legend popup
     *
     *
     * @return HTML document
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- Layer Manager widget hidden -->";

        $szReturn = $this->moButton->DrawPublish();

        return $szReturn;
    }

    /**
     * Parse URL
     *
     * @return
     */
    function  ParseURL()
    {
        return true;
    }

    /**
     * This function updates the layer status in the map file according to the
     * user's selection in the URL.
     *
     * @param oMap object - The map object to update
     * @param szURL string - The URL to parse.
     **/
    function updateLayerStatus( $oMap, $szURL )
    {
        // get the list of layers
        $aszLayers = $szURL["layer_status"];

        // check if is array
        if ( !is_array( $aszLayers ) ) $aszLayers = array();

        // loop through each layer and set it's status
        for ( $i=0; $i<$oMap->numlayers; $i++ )
        {
            // create a layer object
            $oLayer = $oMap->getlayer( $i );

            // check if the name is in the URL
            if ( in_array($oLayer->name, $aszLayers) )
            {
                // set layer to ON
                $oLayer->set("status",MS_ON);
            }
            else
            {
                // set layer to OFF
                $oLayer->set("status",MS_OFF);
            }
        }
    }
}
?>
