<?php
/**
 * LayerAttributes Widget class
 *
 * @project     GeoInnovations 2002 - SECT
 * @revision    $Id: LayerAttributes.widget.php,v 1.1 2004/04/23 17:49:49 pspencer Exp $
 * @purpose     LayerAttributes Widget class puts the attributes of a layer
 *              into a shared resource for the use of a JSList widget
 * @author      DM Solutions Group (dev@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2004, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once('LayerAttributes.php');

/**
 * LayerAttributes Widget
 *
 * @desc a widget that extracts the attributes of a map layer and inserts it
 *       into a SharedResource.
 */
class LayerAttributes extends CWCWidget
{
    /* the name of the shared resource to dump the results into */
    var $mszSharedResourceName;

    /* the index of the layer in the mapfile */
    var $mnAttributeLayerIndex;
    
    var $mszSelectedItem = "";
    
    /**
     * LayerAttributes
     *
     * Constructor method for the LayerAttributes widget.
     */
    function LayerAttributes()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The LayerAttributes widget gets the contents of a mapfile layer and adds an array to
a SharedResource widget in a format suitable for feeding a JSList widget.
The layer to process must be passed in the url as nlayerindex.
EOT;

        $this->maAttributes["SHAREDRESOURCENAME"] =
            new StringAttribute( "SHAREDRESOURCENAME", true );

        $this->maAttributes["LAYERNAME"] =
            new StringAttribute( "LAYERNAME", false );
        $this->maAttributes["ITEM"] =
            new StringAttribute( "ITEM", true, array( "CLASSITEM", "LABELITEM", "TILEITEM", "FILTERITEM", "STYLEITEM" ) );
        $this->maAttributes["ONCHANGE"] =
            new StringAttribute( "ONCHANGE", false );
        $this->maAttributes["VISIBILITY"] =
            new BooleanAttribute( "VISIBILITY", false );
        
    }

    /**
     * initialize respectable defaults
     */
    function InitDefaults()
    {
        parent::InitDefaults();

        if (isset($this->maParams["SHAREDRESOURCENAME"]))
        {
            $this->mszSharedResourceName =
                $this->maParams["SHAREDRESOURCENAME"];
        }
        if (!isset($this->maParams["ONCHANGE"]))
        {
            $this->maParams["ONCHANGE"] = '';
        }
    }

    /**
     * return an array of HTML variables to include in the page
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = array();
        $szVariable = 'nlayerindex';

        return $aReturn;
    }
        
    /**
     * Parse the layer and create the necessary entries in the
     * shared resource.
     */
    function ParseURL()
    {
        $srName = $this->mszSharedResourceName;
        
        $oMap = $this->moMapObject->oMap;
        
        if ($this->isVarSet('initlayername'))
        {
            //this is coming from the main interface
            //convert a named layer into a layer index
            $oLayer = $oMap->getLayerByName( $this->getVar('initlayername') );
            $this->mnAttributeLayerIndex = $oLayer->index;
        }
        elseif($this->isVarSet('initlayerindex'))
        {
            $oLayer = $oMap->getLayer( $this->getVar('initlayerindex') );
            $this->mnAttributeLayerIndex = $oLayer->index;
        }
        else
        {
            //use previously set layer - reloading
            $oLayer = $oMap->getLayer( $this->getVar('nlayerindex') );
            $this->mnAttributeLayerIndex = $oLayer->index;
        }
        
        if ( strcasecmp( $this->maParams['ITEM'], 'classitem' ) == 0 )
            $this->mszSelectedItem = $oLayer->classitem;
        else if ( strcasecmp( $this->maParams['ITEM'], 'labelitem' ) == 0 )
            $this->mszSelectedItem = $oLayer->labelitem;
        else if ( strcasecmp( $this->maParams['ITEM'], 'tileitem' ) == 0 )
            $this->mszSelectedItem = $oLayer->tileitem;
        else if ( strcasecmp( $this->maParams['ITEM'], 'filteritem' ) == 0 )
            $this->mszSelectedItem = $oLayer->filteritem;
        else if ( strcasecmp( $this->maParams['ITEM'], 'styleitem' ) == 0 )
            $this->mszSelectedItem = $oLayer->styleitem;
            
        //:TODO: format results as a proper sr so that
        //we can allow this widget to use it's own drawing
        //or pass it off to a JSList if visiblity=false
        
        //gather attributes and assign them to sharedreosource
        //first check for existing shared resource, then session vars then
        //get it from server/local layer
        if(!(isset($this->maSharedResourceWidgets[$srName]) &&
            count($this->maSharedResourceWidgets[$srName]->maszContents)))
        {
            if (isset($_SESSION[$srName][$oLayer->name]))
            {
                $this->maSharedResourceWidgets[$srName] =
                    $_SESSION[$srName][$oLayer->name];
            }
            else
            {
                $this->maSharedResourceWidgets[$srName]->maszContents =
                                            GetLayerAttributes($oLayer);
                $_SESSION[$srName][$oLayer->name] =
                                            $this->maSharedResourceWidgets[$srName];
            }
        }          
        
        return true;
    }
    
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- LayerAttributes widget hidden -->";
            
        $srName = $this->mszSharedResourceName;        
        $sr = $this->maSharedResourceWidgets[$srName];
        
        //generate an option select list of attributes
        //or a text entry box if there are none.
        if (!count($sr->maszContents))
        {
            $szResult  = '<input TYPE="text" SIZE="10" NAME="';
            $szResult .= $this->maParams['ITEM'].
                        '" ID="' .$this->maParams['ITEM'].
                        '" ONCHANGE="'.
                        $this->maParams['ONCHANGE'];
            $szResult .= '" >'."\n";
        }
        else
        {
            $szResult = '<SELECT NAME="' .$this->maParams['ITEM'].
                        '" id="' .$this->maParams['ITEM'].
                        '" ONCHANGE="'.
                        $this->maParams['ONCHANGE'].
                        '" >'."\n";
            $szResult .= '  <OPTION VALUE="">None'."\n";
            foreach(array_keys($sr->maszContents['fields']) as $szFieldName)
            {
                if ($szFieldName != "LayerType")
                {
                    $szResult .= '  <OPTION VALUE="'. $szFieldName.'"';
                    if (strcasecmp( $szFieldName, $this->mszSelectedItem) == 0)
                        $szResult .= ' SELECTED';
                    $szResult .= '>'. $szFieldName."\n";
                }
            }
            $szResult .= '</SELECT>'."\n";
        }
        
        return $szResult;
    }
}
?>