<?php
/**
 * CWC2 application
 * 
 * @project     CWC2
 * @revision    $Id: 
 * @purpose     This is the tree menu page's supporting php code.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/******************************************************************************/

include( COMMON."treemenu/treemenu.php");
include( COMMON."phpwms/dbf.php");

if (!isset($http_form_vars["p"])) $http_form_vars["p"] = "";

// determine if the treemenu exists
if ( file_exists( $_SESSION["gszServerDataPath"]."server.treemenu" ) )
{
    // create a new instance of the treemenu class
    $oTree = new FileTreeMenu( $_SESSION["gszServerDataPath"]."server.treemenu" );
    $oTree->oErrorManager = $_SESSION['gErrorManager'];

    // set the title
    $oTree->setTitle("<img src=\"".COMMON."phpwms/images/tree_servers_list.gif\" width=20 ".
                     "height=20><font face=\"Arial, Helvetica, sans-serif\" ".
                     "size=3><b>".trim($oMLT->get("5", "Data Stores"))."</b></font>");
    
    // set the callback function
    $oTree->setCallback("processNode");
    
    // restore the previous state
    $oTree->restoreStates($http_form_vars["p"]);
    
    //need to override the +/- clicks with javascript to handle adding SID to all
    //reloads
    $oTree->setScript("nodeClicked");

    $oTree->setMaxNodeNameLength(47);

    // define the font
    $oTree->setFont("<font face=\"Arial, Helvetica, sans-serif\" size=2>");
    
    if (isset($http_form_vars['common']))
        $oTree->m_oTreeMenuImages = new TreeMenuImages(20, 20, $http_form_vars['common']."/treemenu/");
}
else
{
    // display the default tree
    $oTree = new FileTreeMenu( "no_servers.treemenu" );
    $oTree->oErrorManager = $_SESSION['gErrorManager'];

    
    // define the font
    $oTree->setFont("<font face=\"Arial, Helvetica, sans-serif\" size=2>");

    // set the title
    $oTree->setTitle("<font face=\"Arial, Helvetica, sans-serif\" size=3><b>".
           trim($oMLT->get("5", "Data Stores"))."</b></font>");
    // set the callback function
    $oTree->setCallback( "processNode" );
    
    // restore the previous state
    $oTree->restoreStates($http_form_vars["p"]);

    $oTree->setMaxNodeNameLength(47);

    if (isset($http_form_vars['common']))
        $oTree->m_oTreeMenuImages = new TreeMenuImages(20, 20, $http_form_vars['common']."/treemenu/");
}

/**
 * format a single node in a treemenu.
 * 
 * @param $szNode - the full text from the treemenu, will start with @
 * @param $aszTree - a 2D array of table cells that will form the treemenu
 * @param $nRow - the current row (where to put this node)
 * @param $nCol - the current column (where to start this node)
 * @param $nMaxWidth - the last column that the treemenu will use, you can add
 *        additional columns after this and they will all be lined up on the
 *        right of the tree no matter how expanded it becomes
 * @return $aszTree, the treemenu array that was passed in originally
 **/
function processNode( $szNode, $szSelected, $aszTree, $nRow, $nCol, $nMaxWidth, 
                                                 $params, $hasChild, $bExpand )
{
    //strip the @ from the beginning
    $szNode = trim(substr($szNode, 1));
    
    // check for the "no_servers" call back
    if ( $szNode == "no_servers" ) 
    {
        $aszTree[$nRow][$nCol++] = "<font face=\"Arial, Helvetica, ".
                                   "sans-serif\" color=\"red\" size=2>".
                                   "&nbsp;<br>&nbsp;&nbsp;No servers have ".
                                   "been added.".
                                   "<br>&nbsp;&nbsp;Click <a href=\"javascript".
                                   ":manageServers()\">here".
                                   "</a> to add a server.</font>";
     
        // exit the function
        return $aszTree; 
    }   
    
    
    // break apart the text
    $a = explode( '&&', $szNode );
    $layer_id = $a[0];
    $name = $a[1];

    // determine if the node should be a link
    if ( strtoupper( substr( $layer_id, 0, 3 ) ) == "SER" )
    {
        $aServerId = explode("=", $layer_id);

        $result  = "<FONT FACE='Arial, Helvetica, sans-serif' SIZE='2' color=\"#336699\"><b><a href=\"javascript:clickServer(".$aServerId[1].")\">".$name."</a></b></font>";                        
    }
    else
    {
        $aLayerId = explode("=", $layer_id);

        $result  = "<a href='javascript:addLayer(".$aLayerId[1].")'><img border=0 src='../images/icon_add_data.gif'>"; 
        $aszTree[$nRow][$nCol++] = $aszTree[$nRow][$nCol-2];
        $aszTree[$nRow][$nCol-2] = $result;
      
        $result  = "<FONT FACE='Arial, Helvetica, sans-serif' SIZE='2'><a href='javascript:clickLayer(".$aLayerId[1];
        $result .= ")'>".$name."</a></FONT>";
    }
    
    $aszTree[$nRow][$nCol++] = $result;
 
    // return the node
    return $aszTree;
    
// end processNode function    
}

/**
 * This function fetches the layer data for the given layer id and adds it
 * as a layer to the given map object.
 *
 * @param $nLayerID integer - The ID of the layer to fetch.
 * @param $oMap object - The mapscript map object to add the layer to.
 * @return boolean - True if successful, false if not.
 **/
function addWMSLayer( $nLayerID, $oMap, $oErrorManager )
{
    $oWMSDatabase = new WMSDatabase($_SESSION["gszServerDataPath"]);
    $oWMSDatabase->oErrorManager = $_SESSION['gErrorManager'];

/* ============================================================================
 * Step 1 - get capabilities information
 * ========================================================================= */
    // open the capabilities file
    $dbCap = $oWMSDatabase->getDB( DB_CAPABILITIES );

    // check for failure on opening
    if ( $dbCap === false )
    {
        // failed so give message and return
        $oErrorManager->setError( ERR_WARNING, trim($oMLT->get("6", "Failed to open capabilities file"))." [".DB_CAPABILITIES."].");
        return false;
    }

    // locate the record
    $nRecNo = $oWMSDatabase->find_record( $dbCap, "layer_id", $nLayerID );

    // check if found
    if ( $nRecNo === false )
    {
        // not found so give error and return
        $oErrorManager->setError( ERR_WARNING, trim($oMLT->get("7", "LayerID was not found in capabilities file"))." [".DB_CAPABILITIES."]." );
        dbase_close( $dbCap );
        return false;
    }

    // put the record into an associative array
    $axCapRec = dbase_get_record_with_names( $dbCap, $nRecNo );

    // close the database
    dbase_close( $dbCap );

/* ============================================================================
 * Step 2 - get server information
 * ========================================================================= */
    // open the server database
    $dbServ = $oWMSDatabase->getDB( DB_SERVER );

    // check for failure on opening
    if ( $dbServ === false )
    {
        // failed so give message and return
        $oErrorManager->setError( ERR_WARNING, trim($oMLT->get("8", "Failed to open server file"))." [".DB_SERVER."].");
        return false;
    }

    // locate the record
    $nRecNo = $oWMSDatabase->find_record( $dbServ, "server_id", $axCapRec["server_id"] );

    // check if found
    if ( $nRecNo === false )
    {
        // not found so give error and return
        $oErrorManager->setError( ERR_WARNING, "ServerID [".$axCapRec["server_id"].
                        "] was not found in server file [".DB_SERVER."]." );
        dbase_close( $dbServ );
        return false;
    }

    // put the record into an associative array
    $axServRec = dbase_get_record_with_names( $dbServ, $nRecNo );

    // close the database
    dbase_close( $dbServ );

/* ============================================================================
 * Step 3 - get bbox information
 * ========================================================================= */
    // open the bbox database and locate the bbox for the layer
    // there can be 0 or more BBOX
    $szBBOX = "";
    $bbox_id = $axCapRec['bbox_id'];

    // open the bbox database
    $dbBBOX = $oWMSDatabase->getDB( DB_BBOX );

    // check for failure on opening
    if ( $dbBBOX === false )
    {
        // failed so give message and return
        $oErrorManager->setError( ERR_WARNING, "Failed to open bbox file [".
                                                        $dbBBOX."].");
        return false;
    }

    // loop and process ALL bbox ids
    while ($bbox_id >= 0)
    {
        // locate the record
        $nRecNo = $oWMSDatabase->find_record( $dbBBOX, "bbox_id", $bbox_id );

        // check if found
        if ( $nRecNo === false )
        {
            // not found so give error and return
            $oErrorManager->setError( ERR_WARNING, "BBOX ID [".$bbox_id.
                            "] was not found in bbox file [".DB_BBOX."]." );
            dbase_close( $dbBBOX );
            return false;
        }

        // put the record into an associative array
        $axBBOXRec = dbase_get_record_with_names( $dbBBOX, $nRecNo );

        // add to the BBOX string
        $szBBOX .= trim($axBBOXRec['SRS'])." ".
                    $axBBOXRec['minx']." ".$axBBOXRec['miny']." ".
                    $axBBOXRec['maxx']." ".$axBBOXRec['maxy']." ";

        // update the ID
        $bbox_id = $axBBOXRec['next_id'];
    }

    // close the database
    dbase_close( $dbBBOX );

/* ============================================================================
 * Step 3 and a half - get abstract information
 * ========================================================================= */
    if (defined("LAYER_ABSTRACT") && LAYER_ABSTRACT == true &&
        trim($axCapRec["abstractid"]) != -1)
    {
        if (file_exists($_SESSION['gszServerDataPath']."/a".trim(strval($axCapRec["server_id"])).
                        "abstract.txt"))
        {

            // open the abstract text file for the correct server and access the data
            $aFile = file( $_SESSION['gszServerDataPath']."/a".trim(strval($axCapRec["server_id"])).
                                                            "abstract.txt");

            // initialize value
            $szAbstract = "";

            // scan lines until we get to the one that we need
            // 'abstract_id'
            $abstract_id = $axCapRec["abstractid"];
        
            $nAbstract = count($aFile);

            for ($i=0; $i<$nAbstract; $i++)
            {
                if ( $i == $abstract_id )
                {
                    // capture srs information if correct line
                    $szAbstract .= trim( $aFile[$i] );
                }
            }
        }
        else
            $oErrorManager->setError(ERR_WARNING, "Error opening (".$_SESSION['gszServerDataPath']."/s".trim(strval($axCapRec["server_id"]))."abstract.txt)");
    }

/* ============================================================================
 * Step 4 - get srs information
 * ========================================================================= */
    if (trim($axCapRec["srs_ids"]) != "")
    {
        if (file_exists( $_SESSION['gszServerDataPath']."/s".trim(strval($axCapRec["server_id"])).
                         "srs.txt"))
        {
            // open the srs text file for the correct server and access the data
            $fp = fopen( $_SESSION['gszServerDataPath']."/s".trim(strval($axCapRec["server_id"])).
                                                            "srs.txt", "r" );
            // initialize value
            $szSRS = "";

            // scan lines until we get to the one that we need
            // 'srs_ids' contains a comma-delimited list of SRS record ids
            $srs_ids = split(",", $axCapRec["srs_ids"]);
            $i = 0;

            while (!feof ($fp))
            {
                if ( in_array($i, $srs_ids) )
                {
                    // capture srs information if correct line
                    $szSRS .= trim( fgets($fp, 4096) ) ." ";
                }
                else
                {
                    // Just skip this one
                    fgets($fp, 4096);
                }
                // increment the line counter
                $i++;
            }

            // close the file pointer
            fclose( $fp );
        }
        else
            $oErrorManager->setError(ERR_WARNING, trim($oMLT->get("9", "Error opening"))." (".$_SESSION['gszServerDataPath']."/s".trim(strval($axCapRec["server_id"]))."srs.txt)");
    }

/* ============================================================================
 * Step 4 and a half - get style information
 * ========================================================================= */
    if (defined("LAYER_STYLE") && LAYER_STYLE == true)
    {
        // open the style database
        $dbStyle = $oWMSDatabase->getDB( DB_STYLE );

        // check for failure on opening
        if ( $dbStyle === false )
        {
            // failed so give message and return
            $oErrorManager->setError( ERR_WARNING, "Failed to open style file [".
                                                        DB_STYLE."].");
            return false;
        }

        $nStyleID = $axCapRec['style_id'];
        $aStyle = array();
        $bFirst = true;
        $szStyleList = "";
        while ($nStyleID != -1)
        {
            $nStyleRec = $oWMSDatabase->find_record($dbStyle, "style_id", $nStyleID);
            $styleRec = dbase_get_record_with_names($dbStyle, $nStyleRec);

            // validate name and title mapserver don't allow
            // quotes in metadata
            if (strchr($styleRec['name'], "\"") !== false ||
                strchr($styleRec['title'], "\"") !== false)
            {
                $oErrorManager->setError( ERR_FATAL, "NAME or TITLE can't have quote in it.");
                return false;            
            }

            $szStyleList .= ",".trim($styleRec['name']);
            
            if ($bFirst)
            {
                $szStyle = trim($styleRec['name']);
                $bFirst = false;
            }

            $aStyle[trim($styleRec['name'])] = array(trim($styleRec['title']), 
                                               trim($styleRec['leg_width'])." ".
                                               trim($styleRec['leg_height'])." ".
                                               trim($styleRec['leg_format'])." ".
                                               trim($styleRec['legendurl']));


            $nStyleID = $styleRec['next_id'];
        }

        $szStyleList = substr($szStyleList, 1);

        // close the database
        dbase_close( $dbStyle );
    }


/* ============================================================================
 * Step 5 - begin assembling layer information
 * ========================================================================= */
    // set the WMS layer name (replace spaces with "_")
    $szWMSName = trim( $axServRec["name"] )."-".trim( $axCapRec["name"] );
    $szWMSName = ereg_replace(" ", "_", $szWMSName);

    // set type
    $nWMSType = MS_LAYER_RASTER;

    // metadata item - title
    $szWMSMetaData = "wms_title=".trim( $axCapRec["title"] );

    // name
    $szWMSMetaData .= "|wms_name=".trim($axCapRec["name"]);

    // metadata item - server version
    $szWMSMetaData .= "|wms_server_version=".trim($axServRec['version']);

    // map url
    $szWMSMetaData .= "|wms_onlineresource=".urlencode(trim($axServRec['map_url']));

    // queriable
    if ( $axCapRec["queryable"] == 1 )
        $szWMSMetaData .= "|wms_queriable=1";

    // check for the wms_srs metadata
    if ( $szSRS != "" )
        $szWMSMetaData .= "|wms_srs=".$szSRS;

    // check for the wms_abstract metadata
    if ( isset($szAbstract) )
        $szWMSMetaData .= "|wms_abstract=".str_replace("\"", "'", $szAbstract);

    
    // check for the wms_stylelist metadata
    if ( isset($szStyleList) )
        $szWMSMetaData .= "|wms_stylelist=".$szStyleList;

    if ( isset($szStyle))
        $szWMSMetaData .= "|wms_style=".$szStyle;

    if ( isset($aStyle) && is_array($aStyle))
        foreach($aStyle as $szKey => $aStyleAttr)
        {
            $szWMSMetaData .= "|wms_style_".$szKey."_title=".$aStyleAttr[0];
            $szWMSMetaData .= "|wms_style_".$szKey."_legendurl=".urlencode($aStyleAttr[1]);
        }

    // assemble the LLBBOX
    $szLLBBOX = $axCapRec['ll_minx']." ".
                $axCapRec['ll_miny']." ".
                $axCapRec['ll_maxx']." ".
                $axCapRec['ll_maxy'];

    // check for the wms_extents metadata
    if ( $szLLBBOX != "" )
        $szWMSMetaData .= "|wms_latlonboundingbox=".$szLLBBOX;

    // check for BBOX
    if ( $szBBOX != "" )
        $szWMSMetaData .= "|wms_boundingbox=".$szBBOX;

    if (isset($axCapRec["extractabl"]) && $axCapRec["extractabl"] == 1)
        $szWMSMetaData .= "|wms_extractable=1";

    // get the mapscript and WMS versions
    $szVersion = ms_GetVersion();
    $szWMSVersion = trim( $axServRec["version"] );

    // Find an image format recognized by both this client and the remote svr
    $aszFormats = split( ",", trim( $axServRec['formats'] ) );
    $szFormat = "";

    // Try to match formats in this order: GIF, PNG, JPEG
    foreach( array("GIF", "PNG", "JPEG") as $szFmt)
    {
        // Does MapScript support this format?
        if (strpos($szVersion, "OUTPUT=".$szFmt) > 0)
        {
            // Yes... so does the remote server support it as well?
            foreach( $aszFormats as $thisFormat )
            {
                if ( strtoupper(trim($thisFormat)) == $szFmt ||
                     strtoupper(trim($thisFormat)) == "IMAGE/".$szFmt )
                {
                    // Found a match!
                    $szFormat = $thisFormat;
                    break 2;  // Get out of 2 loops
                }
            }
        }
    }

    // metadata item - server format list
    $szWMSMetaData .= "|wms_formatlist=".trim($axServRec['formats']);

    // metadata item - server format
    $szWMSMetaData .= "|wms_format=".$szFormat;

    // check if the layer is queriable
    if ( $axCapRec['queryable'] = "1" )
    {
        // update the query string
        $szQueryLayers = "&QUERY_LAYERS=".urlencode( trim($axCapRec['name']) );
    }
    else
    {
        // update the query string
        $szQueryLayers = "";
    }

    // set connection string
    //printf("usrl = %s <br>", $aszLayer["URL"]);
    $szURL = trim( $axServRec['map_url'] );
    $nLength = strlen( $szURL );
    if (strstr($szURL, '?') !== false)
    {
        if (substr($szURL, -1) != "?" && substr($szURL, -1) != "&")
            $szQuestionMark = "&";
        else
            $szQuestionMark = "";
    }
    else
        $szQuestionMark ="?";

    // build connection string
    $szConnection = $szURL.$szQuestionMark;
    /*              ."SERVICE=WMS&VERSION=".$szWMSVersion
                    ."&LAYERS=".urlencode( trim( $axCapRec['name'] ) )
                    .$szQueryLayers
                    ."&FORMAT=".$szFormat."&TRANSPARENT=TRUE";
    */

    // only add the layer if format is set
    if ($szFormat != "")
    {
        // build an array of layerparameters
        $axParams["metadata"] =  $szWMSMetaData;
        $axParams["connectiontype"] = MS_WMS;
        $axParams["connection"] = $szConnection;

        // create the layer
        addLayer( $oMap, $szWMSName, $nWMSType, $axParams, $oErrorManager );

        // get the current map projection
        $szTempMapProj = $oMap->getprojection();

        // only set the projection if it's set in the map
        if ( strlen( trim( $szTempMapProj ) ) > 0 )
        {
            // set layer projection
            $oLayer = $oMap->getlayerbyname( $szWMSName );
            $oLayer->setprojection( $szTempMapProj );
        }
    }
    else
    {
        $oErrorManager->setError( ERR_WARNING, "Acceptable image format not found" );
    }

    // return success
    return true;

// end addWMSLayer function
}

/**
 * This function adds a new layer to the given mapscript map object.  The
 * layer will NOT be added if the name is already in use.
 *
 * @param $oMap object - Mapscript map object.
 * @param $szName string - New layer name.
 * @param $nType integer - The layer type.
 * @param $axParams array - Mixed associative array of optional layer
 *              properties:
 *              $axParams["status"] - layer status (default = MS_ON)
 *              $axParams["metadata"] - comma de-limited list of metadata
 *                                      items separated by "metadivider".
 *              $axParams["metadivider"] - metadata divider that separates
 *                                      metadata name from value (default = "=")
 *              $axParams["connectiontype"] - connection type
 *              $axParams["connection"] - the connection string
 *              $axParams["group"] - the group name for the layer
 *              $axParams["data"] - the data string
 *              $axParams["scalemin"] - the minimum scale for the layer
 *              $axParams["scalemax"] - the maximum scale for the layer
 *
 * @param $oLog object - The logger object to log events.
 * @return boolean - True if successful, false if not.
 **/
function addLayer( $oMap, $szName, $nType, $axParams, $oErrorManager )
{
    // get an array of all layer names already present in the map
    $aszLayers = $oMap->getAllLayerNames();

    // initialize the variable
    $bLayerFound = false;

    // Check if anything was returned
    if ( is_array( $aszLayers ) )
    {
        // loop through all the layers and determine if name is found
        foreach ( $aszLayers as $szLayer )
        {
            // check for a match
            if ( strtoupper($szLayer) == strtoupper($szName) )
            {
                // set flag
                $bLayerFound = true;

                // exit loop
                break;
            }
        // end foreach
        }
    }

    // only add the layer if the layer is not already present
    if (!$bLayerFound)
    {
        // create the layer object
        $oNewLayer = ms_newLayerObj($oMap);

        // set name
        $oNewLayer->set("name",$szName);

        // set type
        $oNewLayer->set("type",$nType);

        // set status
        if ( isset( $axParams["status"] ) )
            $oNewLayer->set( "status", $axParams["status"] );
        else
            $oNewLayer->set( "status", MS_ON );

        // set group name
        if ( isset( $axParams["group"] ) )
            $oNewLayer->set( "group", $axParams["group"] );

        // set the data tag
        if ( isset( $axParams["data"] ) )
            $oNewLayer->set( "data", $axParams["data"] );

        // set the min scale
        if ( isset( $axParams["scalemin"] ) &&
             is_numeric( $axParams["scalemin"] ) &&
             $axParams["scalemin"] > 0 )
            $oNewLayer->set( "minscale", $axParams["scalemin"] );

        // set the max scale
        if ( isset( $axParams["scalemax"] ) &&
             is_numeric( $axParams["scalemax"] ) &&
             $axParams["scalemax"] >= $axParams["scalemin"] )
            $oNewLayer->set( "maxscale", $axParams["scalemax"] );

        // set metadata
        if ( isset( $axParams["metadata"] ) )
        {
            // determine the metadata divider
            if ( isset( $axParams["metadivider"] ) )
                $sz_meta_div_str = $axParams["metadivider"];
            else
                $sz_meta_div_str = "=";

            // create an array of metadata
            $aszMetaData1 = explode( "|", $axParams["metadata"] );

            // loop and add metadata
            foreach ($aszMetaData1 as $MetaData)
            {
                // separate the value from the label
                $aszMetaData2 = explode( $sz_meta_div_str, $MetaData );

                // add
                $oNewLayer->setMetaData(trim($aszMetaData2[0]),
                                        urldecode(trim($aszMetaData2[1])));
            }
        }

        // set connecttion
        if ( isset( $axParams["connectiontype"] ) )
            $oNewLayer->set( "connectiontype",$axParams["connectiontype"] );

        // set connection string
        if ( isset( $axParams["connection"] ) )
            $oNewLayer->set( "connection", $axParams["connection"] );

        // return success
        $bReturn = true;
    }
    // otherwise the layer exists
    else
    {
        // return failure
        $bReturn = false;
    }

    // return status
    return $bReturn;

// end addLayer function
}
?>
