<?php
/**
 * LayerFeatues Widget class
 *
 * @project     GeoDan OWT Chart
 * @revision    $Id: LayerFeatures.widget.php,v 1.10 2004/05/18 11:36:03 wbronsema Exp $
 * @purpose     LayerFeatures Widget class puts the features of a layer
 *              into a shared resource for the use in a table widget
 * @author      DM Solutions Group (dev@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2004 DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
include_once(dirname(__FILE__)."/../Widget.php");
include_once( dirname(__FILE__)."/../LayerAttributes.php" );

/**
 * LayerFeatures Widget
 *
 * @desc a widget that extracts the features of a map layer and inserts it
 *       into a SharedResource.
 */
class LayerFeatures extends CWCWidget
{
    /* the name of the shared resource to dump the results into */
    var $mszSharedResourceName;
    
    // the name of the layer template mapfile
    var $mszLayerTemplateFile;
    
    /**
     * LayerFeatures
     *
     * Constructor method for the LayerFeatures widget.
     */
    function LayerFeatures()
    {
        // invoke constructor of parent
        parent::CWCWidget();
        
        // set the priority to low so that it is processed almost last
        $this->mnPriority = PRIORITY_LAST;

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The LayerFeatures widget gets the contents of a mapfile layer and adds an array to
a SharedResource widget in a format suitable for feeding a table widget.
The layer to process can be passed in the url as "selectedlayers" or be 
set in the layer's metadata.
EOT;
        $this->maAttributes["SHAREDRESOURCENAME"] =
            new StringAttribute( "SHAREDRESOURCENAME", true );
            
        $this->maAttributes["LAYERTEMPLATEFILE"] =
            new StringAttribute( "LAYERTEMPLATEFILE", true );            
    }

    /**
     * initialize respectable defaults
     */
    function InitDefaults()
    {
        parent::InitDefaults();

        if ( isset( $this->maParams["SHAREDRESOURCENAME"] ) )
        {
            $this->mszSharedResourceName =
                $this->maParams["SHAREDRESOURCENAME"];
        }
        if ( isset( $this->maParams["LAYERTEMPLATEFILE"] ) )
        {
            $this->mszLayerTemplateFile =
                $this->maParams["LAYERTEMPLATEFILE"];
        }                
    }
    
    /**
     * return an array of HTML variables to include in the page
     */
    function GetHTMLHiddenVariables()
    {
        $aReturn = array();
        $szVariable = 'WFS_FILTER';
        $szValue = "<INPUT TYPE=hidden NAME=$szVariable VALUE=\"".
                                        $this->getVar("WFS_FILTER")."\">\n";
        //$szValue = "<INPUT TYPE=text NAME=$szVariable VALUE=\"%3Cor%3E%3CPropertyIsEqualTo%3E%3CPropertyName%3EDIRNAAM%3C%2FPropertyName%3E%3CLiteral%3ELimburg%3C%2FLiteral%3E%3C%2FPropertyIsEqualTo%3E%3CPropertyIsEqualTo%3E%3CPropertyName%3EDIRNAAM%3C%2FPropertyName%3E%3CLiteral%3EZeeland%3C%2FLiteral%3E%3C%2FPropertyIsEqualTo%3E%3C%2For%3E\">\n";
        $aReturn[$szVariable] = $szValue;
        $szVariable = 'WFS_SELECTED_LAYER';
        $szValue = "<INPUT TYPE=hidden NAME=$szVariable VALUE=\"".
                                        $this->getVar("WFS_SELECTED_LAYER")."\">\n";
        $aReturn[$szVariable] = $szValue;                   
        $szVariable = 'LF_CLASS_FILTER';
        $szValue = "<INPUT TYPE=hidden NAME=$szVariable VALUE=\"".
                                            $this->getVar("LF_CLASS_FILTER")."\">\n";
        $aReturn[$szVariable] = $szValue;        
        return $aReturn;
    }
    
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();
        $aReturn = parent::GetJavascriptOnLoadFunctions();
        $szJsFunctionName = "readSRtoJS";
        $szFunction = "$szJsFunctionName();\n";
        $aReturn[$szJsFunctionName] = $szFunction;
        return $aReturn;
    }    
    
    function GetJavascriptVariables()
    {
        $aReturn = array();
        $aReturn = parent::GetJavascriptVariables();
        $aReturn['gaxSRFeatures'] = "var gaxSRFeatures = new Array();\n";
        return $aReturn;
    }
    
    /**
     * Get all the javascript functions
     * shared resource.
     */    
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        
        // loop and build the javascript array
        $szJSArray = '';
        $nCount = count( $this->maSharedResourceWidgets[$this->
                                        mszSharedResourceName]->maszContents );
        for( $i=0; $i<$nCount; $i++ )
        {
            // create a new field array
            $szJSArray .= 'gaxSRFeatures['.$i.'] = new Array();'."\n";
            
            // loop for each field
            $j=0;
            foreach( $this->maSharedResourceWidgets[$this->
                                        mszSharedResourceName]->maszContents[$i] as 
                     $key=>$value )
            {
                // create a new key value array for this field and populate
                $szJSArray .= 'gaxSRFeatures['.$i.']['.$j.'] = new Array();'."\n";
                $szJSArray .= 'gaxSRFeatures['.$i.']['.$j.'][0] = "'.$key.'";'."\n";
                $szJSArray .= 'gaxSRFeatures['.$i.']['.$j.'][1] = "'.$value.'";'."\n";
                $j++;
            }
        }
            
        // add an on load function to make the shared resource into a javascript var
        $szJsFunctionName = "readSRtoJS";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * Convert the shared resource into a javascript array
 */
function {$szJsFunctionName}()
{
    // convert the SR to JS array
    {$szJSArray}

    // return
    return;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

       return $aReturn;
    }
    
        
    /**
     * Parse the layer and create the necessary entries in the
     * shared resource.
     */
    function ParseURL()
    {
        // set the timeout
        set_time_limit( 0 );

        // set shared resource variable
        $srName = $this->mszSharedResourceName;
        
        // set the map object
        $oMap = $this->moMapObject->oMap;
        
        // check of the layer has been passed on the url
        if( $this->isVarSet( "WFS_SELECTED_LAYER" ) && 
             strlen( $this->getVar("WFS_SELECTED_LAYER") ) > 0 )
        {
            $szSelectedLayer = $this->getVar("WFS_SELECTED_LAYER");
        }
        else
        {
            // loop through the layers and check for metadata
            for( $i=0; $i<$oMap->numlayers; $i++ )
            {
                // get layer object and check metadata
                $oLayer = $oMap->getlayer( $i );
                if ( $oLayer->getmetadata("selected") == 1 )
                {
                    $szSelectedLayer = $oLayer->name;
                    break;
                }
            }

            // return an empty array to the shared resource
            if ( !isset( $szSelectedLayer ) )
            {
                $this->maSharedResourceWidgets[$srName]->maszContents = array();
                return true;
            }
        }
        
        // check if the layer name exists
        if ( strlen( $szSelectedLayer ) <= 0 )
        {
            $this->maSharedResourceWidgets[$srName]->maszContents = array();
            return true;            
        }
        
        // get the layer object
        if ( $this->isVarSet( 'LF_CLASS_FILTER' ) && ($this->getVar('LF_CLASS_FILTER') != ""))
				{
        	$oLayer = $this->getWMSLayer( $szSelectedLayer );
       	}
        
        // set wfs_filter
        if ( $this->isVarSet( "WFS_FILTER" ) && 
             strlen( $this->getVar("WFS_FILTER") ) > 0 )
        {
            $oLayer->setmetadata( 'wfs_filter', 
                                    urldecode( $this->getVar("WFS_FILTER") ) );
        }

        // build array of attributes to return
        $aszAttributes = array();
        
        // get and re-order the results for the shared resource
        $aszTmpResults = array();
        $aszResults = GetLayerFeatures( $oMap, $oLayer, $aszAttributes );
               
        // get the layer's features and push them into shared resource
        $this->maSharedResourceWidgets[$srName]->maszContents = $aszResults;
                
        // return success
        return true;
    }

    function getWMSLayer( $szSelectedLayer )
    {
        // init vars
        $oMap = $this->moMapObject->oMap;
        $szTempLayerName = 'layer_features_widget_tmp';
        $szClassItem = '';
        $szClassExpression = '';
        
        // get the class item and expression
        if ( $this->isVarSet( 'LF_CLASS_FILTER' ) )
        {
            $aszClass = explode( ",", urldecode( $this->getVar( 'LF_CLASS_FILTER' ) ) );
            if ( isset( $aszClass[0] ) )
            {
                $szClassItem = $aszClass[0];
            }
            if ( isset( $aszClass[1] ) )
            {
                $szClassExpression = $aszClass[1];
            }
        }
        
        // check if the temp layer exists
        $aszMapLayers = $oMap->getAllLayerNames();
        if ( in_array( $szTempLayerName, $aszMapLayers ) )
        {
            // get layer
            $oLayer =  $oMap->getLayerByName( $szTempLayerName );
        }
        else 
        {
            // create layer from template layer
            $oTemplateMap = ms_newMapObj( $this->mszLayerTemplateFile );
            $oTemplateLayer = $oTemplateMap->getLayer( 0 );
            $oLayer = ms_newLayerObj( $oMap, $oTemplateLayer );
            $oLayer->set( 'name', $szTempLayerName );             
            
        }
        
        // update necessary info
        $oLayer->set( 'classitem', $szClassItem );
        $oLayer->setmetadata( 'wms_name', $szSelectedLayer );
        $oLayer->setmetadata( 'wms_title', $szSelectedLayer );
        $oLayer->setmetadata( 'wms_sld_body', 'AUTO' );       
        
        // get the hilite class and set expression
        $nCount = $oLayer->numclasses;
        for( $i=0; $i<$nCount; $i++ )
        {
            $oClass = $oLayer->getclass($i);
            if ( strtolower( $oClass->name ) == 'hilite' )
            {
                $oClass->setexpression( $szClassExpression );
                break;
            }
        }
        
        // return ponter to new layer
        return $oLayer;
    }    
}

?>