<?php
/**
 * Language Widget class
 *
 * @project     CWC2
 * @revision    $Id: Language.widget.php,v 1.3 2004/05/06 13:57:13 pspencer Exp $
 * @purpose     Language Widget class
 * @author      DM Solutions Group (pspencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");

/**
 * class Language is a hidden widget that sets the language for the
 * current context
 */
class Language extends CWCWidget
{

    /**
     * Construct a new Language instance
     */
    function Language()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Language widget allows the template designer to specify several languages
that the user can switch to from the current template, and makes the current
language available to widgets that support a multilingual interface.  This
widget uses sub-tags in the form: &lt;language name="en-CA"/&gt;.  There is
a javascript function setLanguage that can be used to automatically load the
template associated with a given language while preserving the current context
extents and layer visibility.
EOT;
    }

    /**
     * return the javascript functions required by this widget
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        //build an array of javascript statements that will populate
        //a javascript array with valid language settings, including
        //(name, template, context).  Name is mandatory, the others are
        //optional.
        $szLanguageArray = "";
        if (isset( $this->maszContents["LANGUAGE"] ))
        {
            foreach( $this->maszContents["LANGUAGE"] as $aLang )
            {
                if (!isset( $aLang["NAME"]) )
                    continue;

                $szAppend = "    aLanguages[aLanguages.length] = ";
                $szAppend .= "new Array( ";
                $szAppend .= "\"".$aLang["NAME"]."\"";

                $szLanguageArray .= $szAppend." );\n";
            }
        }

        $szJsFunctionName = "setLanguage";
        $szFunction = <<<EOT
/**
 * set the current language
 */
function {$szJsFunctionName}(szLanguage)
{
    aLanguages = new Array();
{$szLanguageArray}

    //if this is called from a Link widget then the first argument
    //is an object (the button) and the second is the language
    if (arguments.length == 2 && String(szLanguage).length != 5)
    {
        szLanguage = arguments[1];
    }

    bValid = false;
    for( i=0; i< aLanguages.length; i++ )
    {
        if ( aLanguages[i][0] == szLanguage )
        {
            bValid = true;
            break;
        }
    }
    //alert( "setting language" );
    {$this->mszHTMLForm}.LANGUAGE.value = szLanguage;
    {$this->mszHTMLForm}.submit();
    //alert( "after submit" );
    return true;
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * return the form variables required for this widget
     */
    function GetHTMLHiddenVariables()
    {
        $szLanguage = "en-CA";
        if (isset( $_SESSION["gszCurrentLanguage"] ))
        {
            $szLanguage = $_SESSION["gszCurrentLanguage"];
        }

        $szVariable = "LANGUAGE";
        $szValue = " <INPUT TYPE=\"HIDDEN\" NAME=\"$szVariable\" VALUE=\"$szLanguage\">";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }
}
?>
