<?php
/**
* DHTML KeyMap
*
* @project     CWC2
* @revision    $Id:
* @purpose     DHTML KeyMap
* @author      DM Solutions Group (sfournier@dmsolutions.ca)
* @copyright
* <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
* DEALINGS IN THE SOFTWARE.
*/
include_once(dirname(__FILE__)."/../NavTool.php");

/**
* KeyMapDHTMLWidget provides a DHTML enabled mapping interface and the javascript
* functions for doing javascript-based navigation.
*/
class KeyMapDHTML extends NavTool
{
    var $msAnchorName = "keymapanchor";
    var $msMapImageName = "keymapimage";
    var $mszMarqueeColor = "RED";
    var $mnMarqueeWidth = 1;
    var $mszMarqueeImageHorizontal = "images/a_pixel.gif";
    var $mszMarqueeImageVertical = "images/a_pixel.gif";
    var $mszURL = "";
    var $mbAllowResize = true;
    var $mfMinScale = 1;
    var $mfMaxScale = -1;
    
    var $mnWidth = 100;
    var $mnHeight = 100;
    var $mszImage = "";
    var $mdMinx = 0;
    var $mdMiny = 0;
    var $mdMaxx = 0;
    var $mdMaxy = 0;    
    
    var $mszAnchorName = "keyMapAnchor";
    var $mszKeyMapImageName = "KeyMapImage";
    var $mszKeyMapName = "";
    var $mdfZoomMin = 4;
    var $mszMode = "ZOOM";
    
    function KeyMapDHTML()
    {
        // invoke constructor of parent
        parent::NavTool();
        
        $this->SetNavCommand("KEY_MAP_DHTML");
        
        $this->SetUniqueId(md5(uniqid(rand())));
        
        $this->moButton->mszAnchorName = $this->mszAnchorName;
        
        $this->maAttributes["WIDTH"] = new IntegerAttribute( "WIDTH", false, 0 );
        $this->maAttributes["HEIGHT"] = new IntegerAttribute( "HEIGHT", false, 0 );
        $this->maAttributes["IMAGE"] = new StringAttribute( "IMAGE", false );
        $this->maAttributes["COLOR"] = new RGBColorAttribute( "COLOR", false );
        $this->maAttributes["OUTLINECOLOR"] = new RGBColorAttribute( "OUTLINECOLOR", false );
        $this->maAttributes["MINX"] = new FloatAttribute( "MINX", false );
        $this->maAttributes["MINY"] = new FloatAttribute( "MINY", false );
        $this->maAttributes["MAXX"] = new FloatAttribute( "MAXX", false );
        $this->maAttributes["MAXY"] = new FloatAttribute( "MAXY", false );
        $this->maAttributes["SRS"] = new StringAttribute( "SRS", false );
        $this->mszMarqueeImageHorizontal = $_SESSION['gszCoreWebPath']."/skins/default/images/a_pixel.gif";
        $this->mszMarqueeImageVertical = $_SESSION['gszCoreWebPath']."/skins/default/images/a_pixel.gif";
    }
    
    function InitDefaults()
    {
        parent::InitDefaults();
        $oApp = GetChameleonApplication();
        
        // set width
        if (isset($this->maParams['WIDTH']))
        {
            $this->moMapObject->oMap->reference->set( "width", $this->maParams['WIDTH'] );
        }
        
        // set height
        if (isset($this->maParams['HEIGHT']))
        {
            $this->moMapObject->oMap->reference->set( "height", $this->maParams['HEIGHT'] );
        }
        
        // set image
        if (isset($this->maParams['IMAGE']))
        {
            $szImage = $oApp->findFile( $this->maParams['IMAGE'] );
            $this->moMapObject->oMap->reference->set( "image", $szImage );
        }
        else
        {
            $szMapPath = realpath( $_SESSION['gszMapPath'] )."/";
            
            $szImage = $this->moMapObject->oMap->reference->image;
            
            $szImage = realpath($oApp->resolvePath2( $szImage, $szMapPath ));
            $this->moMapObject->oMap->reference->set( "image", $szImage );
            
        }
        
        // set extent
        if (isset($this->maParams['MINX']) && isset($this->maParams['MINY']) &&
            isset($this->maParams['MAXX']) && isset($this->maParams['MAXY']))
        {
            $this->moMapObject->oMap->reference->extent->setextent( $this->maParams['MINX'],
                                                                    $this->maParams['MINY'],
                                                                    $this->maParams['MAXX'],
                                                                    $this->maParams['MAXY'] );
        }        
        
        // intialize member variables
        $this->mnWidth = $this->moMapObject->oMap->reference->width;
        $this->mnHeight = $this->moMapObject->oMap->reference->height;
        $this->mszImage = $this->moMapObject->oMap->reference->image;        
        $this->mdMinx = $this->moMapObject->oMap->reference->extent->minx;
        $this->mdMiny = $this->moMapObject->oMap->reference->extent->miny;
        $this->mdMaxx = $this->moMapObject->oMap->reference->extent->maxx;
        $this->mdMaxy = $this->moMapObject->oMap->reference->extent->maxy;
    }
    
    /**
    * handle changes coming from the URL.  In this case, we only want
    * to verify that the map size is valid
    */
    function ParseURL()
    {
        parent::ParseURL();
        
        $oMap = $this->moMapObject->oMap;
        
        $szCmd = "";
        if ($this->isVarSet("NAV_CMD"))
            $szCmd = trim($this->getVar("NAV_CMD"));
        
        if ($this->isVarSet('KEYMAP_DHTML_MODE'))
            $this->mszMode = $this->getVar('KEYMAP_DHTML_MODE');
        
        if ($szCmd != "" && $this->isVarSet("NAV_INPUT_COORDINATES") &&
            $this->isVarSet("NAV_INPUT_TYPE") &&
            $this->isVarSet("MAP_ORIGINAL_EXTENTS") &&
            $szCmd == "KEYMAP_DHTML")
        {
            if ($this->mszMode == "ZOOM")
            {
                // Restore original full extent
                $aOrigExtents = explode(",", $this->getVar("MAP_ORIGINAL_EXTENTS"));
                $szLastProj = $oMap->getProjection();
/*                if ($this->isVarSet("MAP_ORIGINAL_PROJECTION") &&
                    $this->getVar("MAP_ORIGINAL_PROJECTION") != "")
                {
                    $oMap->setProjection($this->getVar("MAP_ORIGINAL_PROJECTION"), true);
                }
                $oMap->setExtent($aOrigExtents[0], $aOrigExtents[1], $aOrigExtents[2], $aOrigExtents[3]);

*/

                $szInputCoords = "";
                $szInputCoords = $this->getVar("NAV_INPUT_COORDINATES");
                $szInputType = $this->getVar("NAV_INPUT_TYPE");
                
                if ($szInputType == "RECTANGLE")
                {
                    $aPixPos = explode(";", $szInputCoords);
                    $aPixMin = explode(",", $aPixPos[0]);
                    $aPixMax = explode(",", $aPixPos[1]);
                    
                    // adjust ratio of height & width to match main map
                    $this->adjustBBox( $aPixMin[0], $aPixMin[1], $aPixMax[0], $aPixMax[1], 
                                       $oMap->width, $oMap->height );

                    /* -------------------------------------------------------------------- */
                    /*      check if the rectangle is bigger than the minmum size allowed.  */
                    /* -------------------------------------------------------------------- */
                    
                    if (abs($aPixMax[0] - $aPixMin[0]) < $this->mdfZoomMin &&
                       abs($aPixMax[1] - $aPixMin[1]) < $this->mdfZoomMin)
                        return;
                    else
                    {
                        // get x geocoordinates
                        $nGeoMinx = $this->pixel_to_geo($aPixMin[0], 0, $this->mnWidth, $this->mdMinx, $this->mdMaxx);
                        $nGeoMaxx = $this->pixel_to_geo($aPixMax[0], 0, $this->mnWidth, $this->mdMinx, $this->mdMaxx);
                        
                        // get y geocoordinates
                        $nGeoMiny = $this->pixel_to_geo($aPixMin[1], 0, $this->mnHeight, $this->mdMiny, $this->mdMaxy, 1);
                        $nGeoMaxy = $this->pixel_to_geo($aPixMax[1], 0, $this->mnHeight, $this->mdMiny, $this->mdMaxy, 1);

                        // set the map extent                       
                        $oMap->setExtent($nGeoMinx, $nGeoMiny, $nGeoMaxx, $nGeoMaxy);

                    }
                }
                elseif ($szInputType == "POINT")
                {
                    // separate coords
                    $aPix = explode(",", $szInputCoords);

                    // convert to geo
                    $dTmpX = $this->pixel_to_geo($aPix[0], 0, $this->mnWidth, $this->mdMinx, $this->mdMaxx);
                    $dTmpY = $this->pixel_to_geo($aPix[1], 0, $this->mnHeight, $this->mdMiny, $this->mdMaxy, 1);
                    
                    // convert to map pixels
                    $aPix[0] = $this->geo_to_pixel($dTmpX, 0, $oMap->width, $oMap->extent->minx, $oMap->extent->maxx);
                    $aPix[1] = $this->geo_to_pixel($dTmpY, 0, $oMap->height, $oMap->extent->miny, $oMap->extent->maxy, true);

                    // perform zoom
                    $this->moMapNavigator->zoomPoint(2, $aPix[0], $aPix[1]);
                }
                else
                {
                    $_SESSION['gErrorManager']->setError(ERR_WARNING,
                    trim($this->moMLT->get("1", "ERROR: Invalid input type specified in "))." (".$szInputType.") KeyMapDHTML.widget.php.");
                    return;
                }
                
                if ($szLastProj != "")
                {
                    $oMap->setProjection($szLastProj, true);
                }
                /* -------------------------------------------------------------------- */
                /*      Call the reporjectauto function in case the map projection      */
                /*      is set to AUTO:XXX. If it is not, the function will do          */
                /*      nothing.                                                        */
                /* -------------------------------------------------------------------- */
                $this->ReprojectAuto();
            }
            elseif ($this->mszMode == "RECENTER")
            {
                $szInputCoords = "";
                $szInputCoords = $this->getVar("NAV_INPUT_COORDINATES");
                $szInputType = $this->getVar("NAV_INPUT_TYPE");
                
                if(strlen($szInputCoords) <= 0)
                return true;
                
                $nCurrentMinX = $oMap->extent->minx+0;
                $nCurrentMinY = $oMap->extent->miny+0;
                $nCurrentMaxX = $oMap->extent->maxx+0;
                $nCurrentMaxY = $oMap->extent->maxy+0;
                
                $aOrigExtents = explode(",", $this->getVar("MAP_ORIGINAL_EXTENTS"));
                $szLastProj = $oMap->getProjection();
                if ($this->getVar("MAP_ORIGINAL_PROJ") != $szLastProj)
                {
                    $oRect = ms_newRectObj();
                    $oRect->setExtent($aOrigExtents[0], $aOrigExtents[1],
                    $aOrigExtents[2], $aOrigExtents[3]);
                    
                    $oProj1 = ms_newProjectionObj($this->getVar("MAP_ORIGINAL_PROJ"));
                    $oProj2 = ms_newProjectionObj($szLastProj);
                    
                    $oRect->project($oProj1, $oProj2);
                    
                    $aOrigExtents[0] = $oRect->minx;
                    $aOrigExtents[1] = $oRect->miny;
                    $aOrigExtents[2] = $oRect->maxx;
                    $aOrigExtents[3] = $oRect->maxy;
                }
                
                if ($szInputType == "POINT")
                {
                    // separate coords
                    $aPix = explode(",", $szInputCoords);

                    // convert to geo
                    $dTmpX = $this->pixel_to_geo($aPix[0], 0, $this->mnWidth, $this->mdMinx, $this->mdMaxx);
                    $dTmpY = $this->pixel_to_geo($aPix[1], 0, $this->mnHeight, $this->mdMiny, $this->mdMaxy, 1);
                    
                    // convert to map pixels
                    $aPix[0] = $this->geo_to_pixel($dTmpX, 0, $oMap->width, $oMap->extent->minx, $oMap->extent->maxx);
                    $aPix[1] = $this->geo_to_pixel($dTmpY, 0, $oMap->height, $oMap->extent->miny, $oMap->extent->maxy, true);

                    // perform zoom of factor 1 to recenter
                    $this->moMapNavigator->zoomPoint(1, $aPix[0], $aPix[1]);                    

                }
                elseif ($szInputType == "RECTANGLE")
                {
                    // separate coordinates
                    $aPixPos = explode(";", $szInputCoords);
                    $aPixMin = explode(",", $aPixPos[0]);
                    $aPixMax = explode(",", $aPixPos[1]);
                    
                    // comvert to geo
                    $nMinXGeo = $this->pixel_to_geo($aPixMin[0], 0, $this->mnWidth, $this->mdMinx, $this->mdMaxx);
                    $nMaxXGeo = $this->pixel_to_geo($aPixMax[0], 0, $this->mnWidth, $this->mdMinx, $this->mdMaxx);
                    $nMinYGeo = $this->pixel_to_geo($aPixMin[1], 0, $this->mnHeight, $this->mdMiny, $this->mdMaxy, 1);
                    $nMaxYGeo = $this->pixel_to_geo($aPixMax[1], 0, $this->mnHeight, $this->mdMiny, $this->mdMaxy, 1);
                    
                    // calculate offset
                    $nDeltaXGeo = $nMaxXGeo - $nMinXGeo;
                    $nDeltaYGeo = $nMaxYGeo - $nMinYGeo;
                    
                    // offset current extent
                    $oMap->setExtent( $oMap->extent->minx + $nDeltaXGeo, 
                                      $oMap->extent->miny + $nDeltaYGeo,
                                      $oMap->extent->maxx + $nDeltaXGeo, 
                                      $oMap->extent->maxy + $nDeltaYGeo );                    
                }
                else
                {
                    $_SESSION['gErrorManager']->setError(ERR_WARNING,
                    trim($this->moMLT->get("1", "ERROR: Invalid input type specified in"))." Recenter.php.");
                    return true;
                }
                /* -------------------------------------------------------------------- */
                /*      Call the reporjectauto function in case the map projection      */
                /*      is set to AUTO:XXX. If it is not, the function will do          */
                /*      nothing.                                                        */
                /* -------------------------------------------------------------------- */
                
                $this->ReprojectAuto();
            }
        }
        
        // return success
        return true;
    }
    
    /**
    * draw the map DHTML widget interface
    */
    function DrawPublish()
    {
        if (!$this->mbVisible)
        return "<!-- KeyMapDHTML hidden -->";
        
        $url = $_SESSION['gszCoreWebPath']."/skins/default/images/a_pixel.gif";
        
        $nWidth = $this->mnWidth;
        $nHeight = $this->mnHeight;
        
        $szReturn = <<<EOT
<table cellpadding="0" cellspacing="0" border="0">
<tr>
    <td bgcolor="000000"><img src="{$url}" width="1" height="1" id="keymapFrameTL" name="keymapFrameTL"></td>
    <td bgcolor="000000"><img src="{$url}" width="1" height="1"></td>
    <td bgcolor="000000"><img src="{$url}" width="1" height="1" id="keymapFrameTR" name="keymapFrameTR"></td>
  </tr>
  <tr>
    <td bgcolor="000000"><img src="{$url}" width="1" height="1"></td>
    <td><a name="keymapanchor" ><IMG SRC="{$url}" WIDTH="{$nWidth}" HEIGHT="{$nHeight}" NAME="KEYMAPDHTML_1" id="KEYMAPDHTML_1" border="0"></a></td>
    <td bgcolor="000000"><img src="{$url}" width="1" height="1"></td>
  </tr>
  <tr>
    <td bgcolor="000000"><img src="{$url}" width="1" height="1" id="keymapFrameBL" name="keymapFrameBL"></td>
    <td bgcolor="000000"><img src="{$url}" width="1" height="1"></td>
    <td bgcolor="000000"><img src="{$url}" width="1" height="1" id="keymapFrameBR" name="keymapFrameBR"></td>
  </tr>
</table>
EOT;
        return $szReturn;
}


/**
* return an array of javascript functions needed by KeyMapDHTML widget
* @return array of name = function values
*/
function GetJavascriptFunctions()
{
    /* -------------------------------------------------------------------- */
    /*      test if we use the JS API.                                      */
    /* -------------------------------------------------------------------- */
    if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
    $bCWCJSAPI = 1;
    else
    $bCWCJSAPI = 0;
    
    $aReturn = parent::GetJavascriptFunctions();
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWsetZoomBoxSettings                                          */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWsetZoomBoxSettings";
    $szFunction = "function $szJsFunctionName()\n";
    $szFunction .= <<<EOT
{
    if (CWCIsNav4 || CWCIsNav6)
    {
        document.captureEvents(Event.MOUSEMOVE);
        document.captureEvents(Event.MOUSEDOWN);
        document.captureEvents(Event.MOUSEUP);
        document.captureEvents(Event.RESIZE);
    }
    else if (CWCIsIE)
    {
        gMapWhspc -= gMapWhspcIEadjust;
        gMapWvspc += gMapWvspcIEadjust;
    }
    window.onresize = KeyMapWhandleresize;
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWhandleresize                                                */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWhandleresize";
    $szFunction = "function $szJsFunctionName()\n";
    $szFunction .= <<<EOT
{
    if (CWCIsNav4 || CWCIsNav6) 
    {     // Netscape
        location.reload();
    }
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWchkMouseUp                                                  */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWchkMouseUp";
    $szFunction = "function $szJsFunctionName(e)\n";
    $szFunction .= <<<EOT
{
    if (gKeyMapWdragging) 
    {
        gKeyMapWmouseX = Math.min(Math.max(gKeyMapWmouseX, 0), gKeyMapWiWidth);
        gKeyMapWmouseY = Math.min(Math.max(gKeyMapWmouseY, 0), gKeyMapWiHeight);
        KeyMapWmapTool(e);
    }
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWPointNavigation                                             */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWPointNavigation";
    $szFunction = "function $szJsFunctionName()\n";
    $szFunction .= <<<EOT
{
    szCoord = ""+ gKeyMapWmouseX + "," + gKeyMapWmouseY;
    if ({$bCWCJSAPI})
    {
        goCWCJSAPI.NAV_INPUT_COORDINATES = szCoord;
        goCWCJSAPI.NAV_INPUT_TYPE = "POINT";
        
        //the forms variables settings should not be necessary. But It
        //keeps consistancy since some js functions test the values
        //of the form parameters.
        {$this->mszHTMLForm}.NAV_INPUT_COORDINATES.value =  szCoord;
        {$this->mszHTMLForm}.NAV_INPUT_TYPE.value = "POINT";
        
        goCWCJSAPI.UpdateNavTools();
    }
    else
    {
        {$this->mszHTMLForm}.NAV_INPUT_COORDINATES.value =  szCoord;
        {$this->mszHTMLForm}.NAV_INPUT_TYPE.value = "POINT";
        document.onmousemove = null;
        document.onmouseup = null;
        document.onmousedown = null;
        {$this->mszHTMLForm}.submit();
    }
}
EOT;
    
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWmapTool                                                     */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWmapTool";
    $szFunction = "function $szJsFunctionName(e)\n";
    $szFunction .= <<<EOT
{
    if ( CWCIsNav6)
    {
        if (e.target == "[object HTMLHtmlElement]")
        {
            return;
        }
    }
    KeyMapWgetImageXY(e);
        
    /* -------------------------------------------------------------------- */
    /*      if in js api update the js class with the mouse click position. */
    /* -------------------------------------------------------------------- */
    if ({$bCWCJSAPI})
    {
        if (KeyMapWinsideKeyMap())
        {
            goCWCJSAPI.MouseClicked(gKeyMapWmouseX,gKeyMapWmouseY);
        }
    }
    
    if (KeyMapWinsideKeyMap())
    {

        if ({$this->mszHTMLForm}.NAV_ALLOW_RECTANGLE.value == 0)
        {
            //alert({$this->mszHTMLForm}.NAV_ALLOW_RECTANGLE.value);
      //        KeyMapWPointNavigation();
      //        return true;
        }
    }
    if (!gKeyMapWdragging && KeyMapWinsideKeyMap()) {
        KeyMapWstartZoomBox(e);
        return false;
    } 
    else if (gKeyMapWdragging) 
    {
        KeyMapWgetMouse(e);
        KeyMapWstopZoomBox(e);
    }
    return true;
}

EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapgetImageXY                                                   */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWgetImageXY";
    $szFunction = "function $szJsFunctionName(e)\n";
    $szFunction .= <<<EOT
{
    if (CWCIsNav4 || CWCIsNav6) 
    {                // Netscape
        gKeyMapWmouseX = e.pageX;
        gKeyMapWmouseY = e.pageY;
    } 
    else if (CWCIsIE) 
    {            // IE
        gKeyMapWmouseX = event.clientX + document.body.scrollLeft;
        gKeyMapWmouseY = event.clientY + document.body.scrollTop;
    } 
    else 
    {                              // Don't know
        gKeyMapWmouseX = gKeyMapWmouseY = 0;
    }

    // subtract offsets from page left and top
    gKeyMapWmouseX = gKeyMapWmouseX - gKeyMapWhspc;
    gKeyMapWmouseY = gKeyMapWmouseY - gKeyMapWvspc;
}

EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapgetMouse                                                     */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWgetMouse";
    $szFunction = "function $szJsFunctionName(e)\n";
    $szFunction .= <<<EOT
{
    //window.status = "";
    KeyMapWgetImageXY(e);
    
    //make sure that the forms varaibales are initialized.
    //It seems like that in IE, the mouse move may be called before.
    if ({$this->mszHTMLForm} == null ||
    {$this->mszHTMLForm}.KEYMAP_CURSOR_POS_X == null)
        return true;
    
    if (KeyMapWinsideKeyMap())
    {
        {$this->mszHTMLForm}.KEYMAP_CURSOR_POS_X.value = gKeyMapWmouseX;
        {$this->mszHTMLForm}.KEYMAP_CURSOR_POS_Y.value = gKeyMapWmouseY;
        if ({$bCWCJSAPI})
        {
            goCWCJSAPI.oMap.cursorpos[0] = gKeyMapWmouseX;
            goCWCJSAPI.oMap.cursorpos[1] = gKeyMapWmouseY;
        }
    }
    else
    {
        {$this->mszHTMLForm}.KEYMAP_CURSOR_POS_X.value = -1;
        {$this->mszHTMLForm}.KEYMAP_CURSOR_POS_Y.value = -1;
        
        if ({$bCWCJSAPI})
        {
            goCWCJSAPI.oMap.cursorpos[0] = -1;
            goCWCJSAPI.oMap.cursorpos[1] = -1;
        }
        if (document.onmousedown == KeyMapWmapTool)
            document.onmousedown = null;
        if (document.onmouseup == KeyMapWchkMouseUp)
            document.onmouseup = null;
        return true;
    }
    
    document.onmousedown = KeyMapWmapTool;
    document.onmouseup = KeyMapWchkMouseUp;

    if (gKeyMapWdragging) 
    {
        gKeyMapWx2 = gKeyMapWmouseX = Math.min(Math.max(gKeyMapWmouseX, 0), gKeyMapWiWidth);
        gKeyMapWy2 = gKeyMapWmouseY = Math.min(Math.max(gKeyMapWmouseY, 0), gKeyMapWiHeight);

        KeyMapWsetClip();

        return false;
    } 
    else 
    {
        return true;
    }

    return true;
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWinsideKeyMap                                                   */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWinsideKeyMap";
    $szFunction = "function $szJsFunctionName()\n";
    $szFunction .= <<<EOT
{
    return ((gKeyMapWmouseX >= 0) && (gKeyMapWmouseX < gKeyMapWiWidth) &&
            (gKeyMapWmouseY >= 0) && (gKeyMapWmouseY < gKeyMapWiHeight));
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWstartZoomBox                                                */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWstartZoomBox";
    $szFunction = "function $szJsFunctionName(e)\n";
    $szFunction .= <<<EOT
{
    KeyMapWgetImageXY(e);
    // keep it within the KeyMapImage
    if (!gKeyMapWdragging) 
    {
        // capture values to pass to map server
        gKeyMapWfirstx = gKeyMapWx1 = gKeyMapWmouseX;
        gKeyMapWfirsty = gKeyMapWy1 = gKeyMapWmouseY;
        gKeyMapWx2 =  gKeyMapWx1 + 1;
        gKeyMapWy2 =  gKeyMapWy1 + 1;

        CWCDHTML_ClipLayer(gKeyMapWtoplayer, gKeyMapWx1, gKeyMapWy1, gKeyMapWx2, gKeyMapWy2);
        CWCDHTML_ClipLayer(gKeyMapWleftlayer, gKeyMapWx1, gKeyMapWy1, gKeyMapWx2, gKeyMapWy2);
        CWCDHTML_ClipLayer(gKeyMapWrightlayer, gKeyMapWx1, gKeyMapWy1, gKeyMapWx2, gKeyMapWy2);
        CWCDHTML_ClipLayer(gKeyMapWbottomlayer, gKeyMapWx1, gKeyMapWy1, gKeyMapWx2, gKeyMapWy2);
        CWCDHTML_ShowLayer(gKeyMapWtoplayer);
        CWCDHTML_ShowLayer(gKeyMapWleftlayer);
        CWCDHTML_ShowLayer(gKeyMapWrightlayer);
        CWCDHTML_ShowLayer(gKeyMapWbottomlayer);

        gKeyMapWdragging = true;
    } 
    else 
    {
        KeyMapWstopZoomBox(e);
    }
    return false;
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWstopZoomBox                                                 */
    /* -------------------------------------------------------------------- */
    $szJsFunctionName = "KeyMapWstopZoomBox";
    $szFunction = "function $szJsFunctionName(e)\n";
    $szFunction .= <<<EOT
{
    gKeyMapWdragging = false;
    gKeyMapWsecondx = gKeyMapWx2;
    gKeyMapWsecondy = gKeyMapWy2;

    //TODO : values for the smallest rectangle availablee
    if (gKeyMapWfirstx == gKeyMapWsecondx && gKeyMapWfirsty == gKeyMapWsecondy)
    {
        var szCoord = ""+ gKeyMapWfirstx + "," + gKeyMapWfirsty;
        if ({$bCWCJSAPI})
        {
            goCWCJSAPI.NAV_INPUT_COORDINATES = szCoord;
            goCWCJSAPI.NAV_INPUT_TYPE = "POINT";
            //the forms variables settings should not be necessary. But It
            //keeps consistancy since some js functions test the values
            //of the form parameters.
            {$this->mszHTMLForm}.NAV_INPUT_COORDINATES.value = szCoord;
            {$this->mszHTMLForm}.NAV_INPUT_TYPE.value = "POINT";
            goCWCJSAPI.UpdateNavTools();
        }
        else
        {
            {$this->mszHTMLForm}.NAV_INPUT_COORDINATES.value = szCoord;
            {$this->mszHTMLForm}.NAV_INPUT_TYPE.value = "POINT";
            {$this->mszHTMLForm}.NAV_CMD.value = "KEYMAP_DHTML";
            document.onmousemove = null;
            document.onmouseup = null;
            document.onmousedown = null;
            {$this->mszHTMLForm}.submit();
        }
        return true;
    } 
    else 
    {
        // Zoom to box
        if ({$this->mszHTMLForm}.KEYMAP_DHTML_MODE.value == "ZOOM")
    {
            var tx1 = Math.min(gKeyMapWfirstx, gKeyMapWsecondx);
            var tx2 = Math.max(gKeyMapWfirstx, gKeyMapWsecondx);
            var ty1 = Math.min(gKeyMapWfirsty, gKeyMapWsecondy);
            var ty2 = Math.max(gKeyMapWfirsty, gKeyMapWsecondy);
    }
    else
    {
        var tx1 = gKeyMapWfirstx;
            var tx2 = gKeyMapWsecondx;
            var ty1 = gKeyMapWfirsty;
            var ty2 = gKeyMapWsecondy;
    }
        
        var szCoord = ""+ tx1 + "," + ty1 + ";" + tx2 + "," + ty2;

        if ({$bCWCJSAPI})
        {
            //goCWCJSAPI.NAV_CMD = "ZOOM_IN";
            goCWCJSAPI.NAV_INPUT_COORDINATES = szCoord;
            goCWCJSAPI.NAV_INPUT_TYPE = "RECTANGLE";
            
            //the forms variables settings should not be necessary. But It
            //keeps consistancy since some js functions test the values
            //of the form parameters.
            {$this->mszHTMLForm}.NAV_INPUT_COORDINATES.value = szCoord;
            {$this->mszHTMLForm}.NAV_INPUT_TYPE.value = "RECTANGLE";
            
            CWCDHTML_HideLayer("zKeyMapBoxTop");
            CWCDHTML_HideLayer("zKeyMapBoxLeft");
            CWCDHTML_HideLayer("zKeyMapBoxRight");
            CWCDHTML_HideLayer("zKeyMapBoxBottom");
            goCWCJSAPI.UpdateNavTools();
        }
        else
        {
            {$this->mszHTMLForm}.NAV_INPUT_COORDINATES.value = szCoord;
            {$this->mszHTMLForm}.NAV_INPUT_TYPE.value = "RECTANGLE";
            {$this->mszHTMLForm}.NAV_CMD.value = "KEYMAP_DHTML";
            document.onmousemove = null;
            document.onmouseup = null;
            document.onmousedown = null;
            {$this->mszHTMLForm}.submit();
        }
        return true;
    }
    return false;
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWsetClip                                                     */
    /* -------------------------------------------------------------------- */
    $oMap = $this->moMapObject->oMap;
    
    $nMinx = $oMap->extent->minx;
    $nMiny = $oMap->extent->miny;
    $nMaxx = $oMap->extent->maxx;
    $nMaxy = $oMap->extent->maxy;
    
    $nRefMinx = $oMap->reference->extent->minx;
    $nRefMiny = $oMap->reference->extent->miny;
    $nRefMaxx = $oMap->reference->extent->maxx;
    $nRefMaxy = $oMap->reference->extent->maxy;
       
    // calculate the bounding pixels of the box to draw
    $aOrigExtents = array($nRefMinx, $nRefMiny, $nRefMaxx, $nRefMaxy);
    $nLeft = $this->geo_to_pixel($nMinx, 0, $oMap->reference->width, $aOrigExtents[0], $aOrigExtents[2]);
    $nTop = $this->geo_to_pixel($nMaxy, 0, $oMap->reference->height, $aOrigExtents[1], $aOrigExtents[3], true);
    $nRight = $this->geo_to_pixel($nMaxx, 0, $oMap->reference->width, $aOrigExtents[0], $aOrigExtents[2]);
    $nBottom = $this->geo_to_pixel($nMiny, 0, $oMap->reference->height, $aOrigExtents[1], $aOrigExtents[3], true);
       
    $szJsFunctionName = "KeyMapWsetClip";
    $szFunction = "function $szJsFunctionName()\n";
    $szFunction .= <<<EOT
{
    gKeyMapWzright  = Math.max(gKeyMapWx1, gKeyMapWx2);
    gKeyMapWzleft   = Math.min(gKeyMapWx1, gKeyMapWx2);
    gKeyMapWzbottom = Math.max(gKeyMapWy1, gKeyMapWy2);
    gKeyMapWztop    = Math.min(gKeyMapWy1, gKeyMapWy2);
    
    if ((gKeyMapWx1 != gKeyMapWx2) && (gKeyMapWy1 != gKeyMapWy2)) 
    {
        var ovBoxSize = {$this->mnMarqueeWidth};

    if ({$this->mszHTMLForm}.KEYMAP_DHTML_MODE.value == "ZOOM")
        {
            CWCDHTML_ClipLayer(gKeyMapWtoplayer, gKeyMapWzleft, gKeyMapWztop, gKeyMapWzright, gKeyMapWztop + ovBoxSize);
            CWCDHTML_ClipLayer(gKeyMapWleftlayer, gKeyMapWzleft, gKeyMapWztop, gKeyMapWzleft + ovBoxSize, gKeyMapWzbottom);
            CWCDHTML_ClipLayer(gKeyMapWrightlayer, gKeyMapWzright - ovBoxSize, gKeyMapWztop, gKeyMapWzright, gKeyMapWzbottom);
            CWCDHTML_ClipLayer(gKeyMapWbottomlayer, gKeyMapWzleft, gKeyMapWzbottom - ovBoxSize, gKeyMapWzright, gKeyMapWzbottom);
    }
    else
    {// recenter
        var nXDiff = gKeyMapWx2 - gKeyMapWx1;
        var nYDiff = gKeyMapWy2 - gKeyMapWy1;
        var nLeft = {$nLeft};
        var nTop = {$nTop};
        var nRight = {$nRight};
        var nBottom = {$nBottom};

            CWCDHTML_ClipLayer(gKeyMap2Wtoplayer, nLeft+nXDiff,nTop+nYDiff,nRight+nXDiff,nTop+nYDiff+1);
            CWCDHTML_ClipLayer(gKeyMap2Wleftlayer, nLeft+nXDiff,nTop+nYDiff,nLeft+nXDiff+1,nBottom+nYDiff);
        CWCDHTML_ClipLayer(gKeyMap2Wrightlayer, nRight+nXDiff-1,nTop+nYDiff,nRight+nXDiff,nBottom+nYDiff);
        CWCDHTML_ClipLayer(gKeyMap2Wbottomlayer, nLeft+nXDiff,nBottom+nYDiff-1,nRight+nXDiff,nBottom+nYDiff);
    }

    }
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    $szJsFunctionName = "KeyMapWCaptureMouse";
    $szFunction = "function $szJsFunctionName()\n";
    $szFunction .= <<<EOT
{
    document.onmousemove = CWC2OnMouseMoveFunction;
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    $szJsFunctionName = "KeyMapWReleaseMouse";
    $szFunction = "function $szJsFunctionName()\n";
    $szFunction .= <<<EOT
{
    document.onmousemove = null;
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      KeyMapWCreateDHTMLLayers                                            */
    /* -------------------------------------------------------------------- */
    $oApp = GetChameleonApplication();
    
    $url = $oApp->fileSystemToURL( $this->mszImage );
    $szJsFunctionName = "KeyMapWCreateDHTMLLayers";
    $szFunction = "function $szJsFunctionName()\n";
    $szAPixel = $_SESSION['gszCoreWebPath']."/skins/default/images/a_pixel.gif";
    $szFunction .= <<<EOT
{
    var content = "";
    //panning layer
    
    CWCDHTML_CreateLayer("KeyMapLayerBG", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                         true, content);
    CWCDHTML_SetLayerBackgroundColor("KeyMapLayerBG", 'WHITE');
    CWCDHTML_SetLayerZOrder( "KeyMapLayerBG", 10 );
    
    content = "<img name=\"KeyMapLayerDivImg\" src=\"{$szAPixel}\" width=\""+{$this->mnWidth}+"\" height=\""+{$this->mnHeight}+"\" border=\"0\" onload=\"\" onmouseover=\"KeyMapWCaptureMouse();\" onmouseout=\"KeyMapWReleaseMouse();\">";
    CWCDHTML_CreateLayer("KeyMapLayerDiv", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                          true, content);
    CWCDHTML_SetLayerZOrder( "KeyMapLayerDiv", 11 );
    
    content = '<img name="zKeyMapImgTop" src="{$this->mszMarqueeImageVertical}" border="1">';
    CWCDHTML_CreateLayer("zKeyMapBoxTop", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( "zKeyMapBoxTop", 12 );
    
    content = '<img name="zKeyMapImgLeft" src="{$this->mszMarqueeImageHorizontal}" border="1">';
    CWCDHTML_CreateLayer("zKeyMapBoxLeft", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( "zKeyMapBoxLeft", 12 );    
    
    content = '<img name="zKeyMapImgBottom" src="{$this->mszMarqueeImageVertical}" border="1">';
    CWCDHTML_CreateLayer("zKeyMapBoxBottom", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( "zKeyMapBoxBottom", 12 );
    
    content = '<img name="zKeyMapImgRight" src="{$this->mszMarqueeImageHorizontal}" border="1">';
    CWCDHTML_CreateLayer("zKeyMapBoxRight", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                         false, content);
    CWCDHTML_SetLayerZOrder( "zKeyMapBoxRight", 12 );

    content = '<img name="zKeyMap2ImgTop" src="{$this->mszMarqueeImageVertical}" border="1">';
    CWCDHTML_CreateLayer("zKeyMap2BoxTop", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                         true, content);
    CWCDHTML_SetLayerZOrder( "zKeyMap2BoxTop", 12 );

    content = '<img name="zKeyMap2ImgLeft" src="{$this->mszMarqueeImageHorizontal}" border="1">';
    CWCDHTML_CreateLayer("zKeyMap2BoxLeft", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                         true, content);
    CWCDHTML_SetLayerZOrder( "zKeyMap2BoxLeft", 12 );
    
    content = '<img name="zKeyMap2ImgBottom" src="{$this->mszMarqueeImageVertical}" border="1">';
    CWCDHTML_CreateLayer("zKeyMap2BoxBottom", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                         true, content);
    CWCDHTML_SetLayerZOrder( "zKeyMap2BoxBottom", 12 );
    
    content = '<img name="zKeyMap2ImgRight" src="{$this->mszMarqueeImageHorizontal}" border="1">';
    CWCDHTML_CreateLayer("zKeyMap2BoxRight", gKeyMapWhspc, gKeyMapWvspc, gKeyMapWiWidth, gKeyMapWiHeight,
                         true, content);
    CWCDHTML_SetLayerZOrder( "zKeyMap2BoxRight", 12 );

    
    boundingColor = '{$this->mszMarqueeColor}';
    CWCDHTML_SetLayerBackgroundColor("zKeyMapBoxTop", boundingColor);
    CWCDHTML_SetLayerBackgroundColor("zKeyMapBoxLeft", boundingColor);
    CWCDHTML_SetLayerBackgroundColor("zKeyMapBoxRight", boundingColor);
    CWCDHTML_SetLayerBackgroundColor("zKeyMapBoxBottom", boundingColor);

    CWCDHTML_SetLayerBackgroundColor("zKeyMap2BoxTop", boundingColor);
    CWCDHTML_SetLayerBackgroundColor("zKeyMap2BoxLeft", boundingColor);
    CWCDHTML_SetLayerBackgroundColor("zKeyMap2BoxRight", boundingColor);
    CWCDHTML_SetLayerBackgroundColor("zKeyMap2BoxBottom", boundingColor);

    var nLeft = {$nLeft};
    var nTop = {$nTop};
    var nRight = {$nRight};
    var nBottom = {$nBottom};

    // Create the red rectangle that will show wich part of the map is shown.
    CWCDHTML_ClipLayer(gKeyMap2Wtoplayer, nLeft,nTop,nRight,nTop+1);
    CWCDHTML_ClipLayer(gKeyMap2Wleftlayer, nLeft,nTop,nLeft+1,nBottom);
    CWCDHTML_ClipLayer(gKeyMap2Wrightlayer, nRight-1,nTop,nRight,nBottom);
    CWCDHTML_ClipLayer(gKeyMap2Wbottomlayer, nLeft,nBottom-1,nRight,nBottom);
}

EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    /* -------------------------------------------------------------------- */
    /*       Initilalization function called from on load.                  */
    /* -------------------------------------------------------------------- */
    $nWidth = $this->mnWidth;
    $nHeight = $this->mnHeight;
    $szJsFunctionName = "KeyMapWidgetInitVariables";
    $szFunction = "function $szJsFunctionName()\n";
    $szFunction .= <<<EOT
{
    CWCIsNav4 = (document.layers) ? 1:0;
    
    CWCIsIE = (document.all) ? 1:0;
    CWCIsNav6 = (document.getElementById && !document.all) ? 1:0;
    
    // Constants
    gKeyMapWvspcIEadjust = 0;// orginal code was 7;
    gKeyMapWhspcIEadjust = 0;// orginal code was -2;
    gKeyMapWiWidth = {$nWidth};
    gKeyMapWiHeight = {$nHeight};
    gKeyMapWhspc = 0;
    gKeyMapWvspc = 0;
    
    if (document.layers) //Netscape 4.x
    {
        gKeyMapWhspc = document.images['keymapFrameTL'].x;
        gKeyMapWvspc = document.images['keymapFrameTL'].y;
    }
    else
    {
        gKeyMapWhspc = CWCDHTML_FindObjectPosX( document.getElementById('keymapFrameTL'));
        gKeyMapWvspc = CWCDHTML_FindObjectPosY( document. getElementById('keymapFrameTL'));
    }
    
    gKeyMapWhspc+=1;
    gKeyMapWvspc+=1;
    
    KeyMapWsetZoomBoxSettings();
    KeyMapWCreateDHTMLLayers();
}
EOT;
    $aReturn[$szJsFunctionName] = $szFunction;
    
    
    /* -------------------------------------------------------------------- */
    /*      if we use the JS API, add functions that will be called on      */
    /*      events happning on the map.                                     */
    /* -------------------------------------------------------------------- */
    if ($bCWCJSAPI)
    {
        $szJsFunctionName = "KeyMapWKeyMapExtentsChanged";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to initialize the JS API widget
 */
function {$szJsFunctionName}()
{
    var sImgName = "KeyMapLayerDivImg";
    var url = "{$url}";
    var d = new Date();
    var unique = d.getTime() + '' + Math.floor(1000 * Math.random());
    url = url + "&UniqId="+unique;
    if (navigator.appName == "Netscape" && navigator.appVersion[0] <= 4)
    {
        document.layers["KeyMapLayerDiv"].document.images[0].src=url; //for netscape4
    }
    else
    {
        document.images["KeyMapLayerDivImg"].src = url;  //for IE and Netscape6 works
    }
}
EOT;
        
        $aReturn[$szJsFunctionName] = $szFunction;
        
        $bAllowResize = 0;
        if ($this->mbAllowResize)
        $bAllowResize = 1;
        $szJsFunctionName = "KeyMapWRegisterForEvent";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to create a dynamic layer
 */
function {$szJsFunctionName}()
{
    goCWCJSAPI.RegisterEvent(MAP_EXTENT_CHANGED, "KeyMapWKeyMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(LAYER_STATUS_CHANGED, "KeyMapWKeyMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(LAYER_ORDER_CHANGED, "KeyMapWKeyMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(LAYER_STYLE_CHANGED, "KeyMapWKeyMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(MAP_NEW_LAYER_ADDED, "KeyMapWKeyMapExtentsChanged");
    goCWCJSAPI.RegisterEvent(MAP_NEW_ELEMENT_ADDED, "KeyMapWKeyMapExtentsChanged");

    //set the js map object to allow resizing or not.
    goCWCJSAPI.oKeyMap.bAllowResize = {$bAllowResize};
}
EOT;
        
        $aReturn[$szJsFunctionName] = $szFunction;
        
        
    }
    
    $szJsFunctionName = "KeyMapLayerDivImgOnLoad";
    
    $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to initialize the map image after the page has loaded
 */
function {$szJsFunctionName}()
{
    var sImgName = "KeyMapLayerDivImg";
    var url = "{$url}";
    var d = new Date();
    var unique = d.getTime() + '' + Math.floor(1000 * Math.random());

    if (navigator.appName == "Netscape" && navigator.appVersion[0] <= 4)
    {
        document.layers["KeyMapLayerDiv"].document.images[0].src=url; //for netscape4
    }
    else
    {
        document.images["KeyMapLayerDivImg"].src = url;  //for IE and Netscape6 works
    }
}
EOT;
    
    $aReturn[$szJsFunctionName] = $szFunction;
    
    $szJsFunctionName = "KeyMapWHideActivityLayer";
    
    $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called to initialize the map image after the page has loaded
 */
function {$szJsFunctionName}()
{
    var szImage = null;
    if (navigator.appName == "Netscape" && navigator.appVersion[0] <= 4)
    {
       szImage = document.layers["KeyMapLayerDiv"].document.images[0].src;
    }
    else
    {
        szImage = document.images["KeyMapLayerDivImg"].src;  //for IE and Netscape6 works
    }
    if (szImage != null && szImage.indexOf( 'a_pixel' ) == -1)
    {
        CWCDHTML_HideLayer('ActivityLayer');
        CWCDHTML_ShowLayer('KeyMapLayerDiv');
    }
    
}
EOT;
    
    $aReturn[$szJsFunctionName] = $szFunction;
    
    return $aReturn;
}



/**
* GetJavascriptOnMouseMoveFunctions
*
* Returns functions to be called on mouse mouve event.
*/
function GetJavascriptOnMouseMoveFunctions()
{
    $aReturn = array();
    $szJsFunctionName = "KeyMapWgetMouse";
    $szFunction = "$szJsFunctionName(e);\n";
    $aReturn[$szJsFunctionName] = $szFunction;
    
    return $aReturn;
}

/**
* GetJavascriptOnMouseUpFunctions.
*
*/
function GetJavascriptOnMouseUpFunctions2()
{
    $aReturn = array();
    $szJsFunctionName = "KeyMapWchkMouseUp";
    $szFunction = "$szJsFunctionName(e);\n";
    $aReturn[$szJsFunctionName] = $szFunction;
    
    return $aReturn;
}

/**
* GetJavascriptOnMouseDownFunctions
*
*/
function GetJavascriptOnMouseDownFunctions2()
{
    $aReturn = array();
    $szJsFunctionName = "KeyMapWmapTool";
    $szFunction = "$szJsFunctionName(e);\n";
    $aReturn[$szJsFunctionName] = $szFunction;
    
    return $aReturn;
}


/**
* GetJavascriptOnLoadFunctions
*
* On load functions.
*/
function GetJavascriptOnLoadFunctions()
{
    $aReturn = array();
    
    $aReturn['KeyMapLayerDivImgOnLoad'] = "KeyMapLayerDivImgOnLoad();\n";
    
    if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
    {
        $szJsFunctionName = "KeyMapWRegisterForEvent";
        $szFunction = "$szJsFunctionName();\n";
        $aReturn[$szJsFunctionName] = $szFunction;
    }
    
    return $aReturn;
}



/**
* GetJavascriptInitFunctions
*
* Functions to be called at the end of the load.
*/
function GetJavascriptInitFunctions()
{
    $aReturn = array();
    
    $szJsFunctionName = "KeyMapWidgetInitVariables";
    //$szFunction = "setTimeout('$szJsFunctionName()',5000);";
    $szFunction = "$szJsFunctionName();\n";
    $aReturn[$szJsFunctionName] = $szFunction;
    
    return $aReturn;
}

/**
* GetJavascriptIncludeFunctions
*/
function GetJavascriptIncludeFunctions()
{
    $aReturn = parent::GetJavascriptIncludeFunctions();
    
    $szJsIncludeName = "cwc_dhtml.js";
    $szInclude = '<script language="JavaScript" src="'.$_SESSION["gszCoreWebPath"]."/widgets/js/cwc_dhtml.js".'"></script>';
    $aReturn[$szJsIncludeName] = $szInclude;
    
    return $aReturn;
}

/**
* GetJavascriptVariables
*
* Return JS global variables and global code.
*/
function GetJavascriptVariables()
{
    $aReturn = array();
    
    $szVariable = "gKeyMapWvspcIEadjust";
    $szValue = " var $szVariable = 7;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWhspcIEadjust";
    $szValue = " var $szVariable = -2;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWiWidth";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWiHeight";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWhspc";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWvspc";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWmouseX";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWmouseY";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWx1";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWy1";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWx2";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWy2";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWfirstx";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWfirsty";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWsecondx";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWsecondy";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWzleft";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWzright";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWztop";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWzbottom";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWmapX";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWmapY";
    $szValue = " var $szVariable = 0;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWdragging";
    $szValue = " var $szVariable = false;\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWtoplayer";
    $szValue = " var $szVariable = \"zKeyMapBoxTop\";\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWleftlayer";
    $szValue = " var $szVariable = \"zKeyMapBoxLeft\";\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWbottomlayer";
    $szValue = " var $szVariable = \"zKeyMapBoxBottom\";\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMapWrightlayer";
    $szValue = " var $szVariable = \"zKeyMapBoxRight\";\n";
    $aReturn[$szVariable] = $szValue;
    
    
    $szVariable = "gKeyMap2Wtoplayer";
    $szValue = " var $szVariable = \"zKeyMap2BoxTop\";\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMap2Wleftlayer";
    $szValue = " var $szVariable = \"zKeyMap2BoxLeft\";\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMap2Wbottomlayer";
    $szValue = " var $szVariable = \"zKeyMap2BoxBottom\";\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "gKeyMap2Wrightlayer";
    $szValue = " var $szVariable = \"zKeyMap2BoxRight\";\n";
    $aReturn[$szVariable] = $szValue;
    
    return $aReturn;
}

/**
* GetHTMLHiddenVariables
*
* Return HTML hidden variables.
*/
function GetHTMLHiddenVariables()
{
    $szVariable = "NAV_INPUT_TYPE";
    $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "NAV_INPUT_COORDINATES";
    $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "KEYMAP_CURSOR_POS_X";
    $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "KEYMAP_CURSOR_POS_Y";
    $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
    $aReturn[$szVariable] = $szValue;
    
    $szCmd = '';
    if ($this->isVarSet('NAV_CMD'))
        $szCmd = $this->getVar('NAV_CMD');
    $szVariable = "NAV_CMD";
    $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "KEYMAP_NAV_ALLOW_RECTANGLE";
    $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
    $aReturn[$szVariable] = $szValue;
    
    $szVariable = "KEYMAP_DHTML_MODE";
    $szValue = " <INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"ZOOM\">\n";
    $aReturn[$szVariable] = $szValue;
    
    return $aReturn;
}
/**
* convert a pixel position to geocoded position
*
* @param nPixPos double pixel position
* @param dfPixMin double minimum map pixel value
* @param dfPixMax double maximum map pixel value
* @param dfGeoMin double minimum map geocoded value
* @param dfGeoMax double maximum map geocoded value
* @param nInversePix integer optional flag to inverse , set to 1 for
*                            Y pixel coordinates where UL > LR
* @return double geocoded position
*/
function pixel_to_geo($nPixPos, $dfPixMin, $dfPixMax, $dfGeoMin, $dfGeoMax,
$nInversePix = "")
{
    // calculate the geocoded & pixel width
    $dfWidthGeo = $dfGeoMax - $dfGeoMin;
    $dfWidthPix = $dfPixMax - $dfPixMin;
    
    // get ratio
    if ( $dfWidthPix <= 0 )
    {
        return 0;
    }    
    $dfPixToGeo = $dfWidthGeo / $dfWidthPix;
    
    // get difference
    if (!$nInversePix)
    $dfDeltaPix = $nPixPos - $dfPixMin;
    else
    $dfDeltaPix = $dfPixMax - $nPixPos;
    
    // calculate
    $dfDeltaGeo = $dfDeltaPix * $dfPixToGeo;
    $dfPosGeo = $dfGeoMin + $dfDeltaGeo;
    
    // return value
    return ($dfPosGeo);
    
    // end pixel_to_geo function
}


/**
* convert a geocoded position to pixel coord
*
* @param nGeoPos double Geocoded position
* @param dfPixMin double minimum map pixel value
* @param dfPixMax double maximum map pixel value
* @param dfGeoMin double minimum map geocoded value
* @param dfGeoMax double maximum map geocoded value
* @param nInverseGeo integer optional flag to inverse , set to 1 for
*                            Y pixel coordinates where UL > LR
* @return double geocoded position
*/
function geo_to_pixel ($nGeoPos, $dfPixMin, $dfPixMax, $dfGeoMin,
$dfGeoMax, $nInverseGeo = "")
{
    // calculate the geocoded & pixel width
    $dfWidthGeo = abs($dfGeoMax - $dfGeoMin);
    $dfWidthPix = abs($dfPixMax - $dfPixMin);
    
    // get ratio
    if ( $dfWidthGeo <= 0 )
    {
        return 0;
    }
    $dfGeoToPix = $dfWidthPix / $dfWidthGeo;
    
    // get difference
    if (!$nInverseGeo)
    $dfDeltaGeo = $nGeoPos - $dfGeoMin;
    else
    $dfDeltaGeo = $dfGeoMax - $nGeoPos;
    
    // calculate
    $dfDeltaPix = $dfDeltaGeo * $dfGeoToPix;
    $dfPosPix = $dfPixMin + $dfDeltaPix;
    
    // return value
    return round ($dfPosPix);
    
    // end pixel_to_geo function
}
    /**
     * adjustBBox()
     * 
     * Postcondition:  This function adjusts a user supplied pixel bbox to the correct ratio 
     *                 of the mainmap
     *
     */
    function adjustBBox( &$nMinx, &$nMiny, &$nMaxx, &$nMaxy, $nMapWidth, $nMapHeight  )
    {
        // calculate center pixel values
        $nMidX = (($nMaxx - $nMinx)/2) + $nMinx;
        $nMidY = (($nMaxy - $nMiny)/2) + $nMiny;

        // adjust according to which dimension is furthest out
        if ( ($nMaxx-$nMinx)/$nMapWidth > ($nMaxy-$nMiny)/$nMapHeight )
        {
            // calculate the pixel width of zoom box
            $nPixDist = $nMaxx - $nMinx;
          
            // determine main map width and height ratio
            $dMainMapRatio = $nMapHeight/$nMapWidth;
           
            // convert the pixel values to be in the same ratio as the main map
            $nConvertedPixWidth =  $nPixDist;
            $nConvertedPixHeight = $dMainMapRatio * $nPixDist;
        }
        else
        {
            // calculate the pixel height of zoom box
            $nPixDist = $nMaxy - $nMiny;
          
            // determine main map width and height ratio
            $dMainMapRatio = $nMapWidth/$nMapHeight;
           
            // convert the pixel values to be in the same ratio as the main map
            $nConvertedPixWidth =  $dMainMapRatio * $nPixDist;
            $nConvertedPixHeight = $nPixDist;
        }

        // update the coordinates
        $nMinx = $nMidX - ($nConvertedPixWidth/2);
        $nMaxx = $nMidX + ($nConvertedPixWidth/2);
        $nMiny = $nMidY - ($nConvertedPixHeight/2);
        $nMaxy = $nMidY + ($nConvertedPixHeight/2);   
       
    }
}
?>
