<?php
/**
 * KeepSessionAlive Widget Class
 *
 * @project     IOOS
 * @revision    $Id: KeepSessionAlive.widget.php,v 1.5 2004/07/08 15:58:57 pspencer Exp $
 * @purpose     Display a dialog box to type in coordinates to zoom to
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
/*
 * This widget is an invisible widget that needs to be placed somewhere
 * inside the body of the page.  It represents itself as an invisible
 * 1x1 pixel image.  The widget refreshes the contents of the pixel
 * on a regular (configurable) basis in order to keep the associated
 * PHP session alive.
 */


include_once(dirname(__FILE__)."/../Widget.php");

/**
 * KeepSessionAlive
 *
 * @desc Keep the current session alive
 */
class KeepSessionAlive extends CWCWidget
{
    var $mnTimeout;

    /**
     * KeepSessionAlive
     *
     * Constctor method for the KeepSessionAlive
     */
    function KeepSessionAlive()
    {
        parent::CWCWidget();

        $this->maAttributes['TIMEOUT'] = new IntegerAttribute( 'TIMEOUT', false, 0, 1800 );

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The BoundingBoxPopupWidget displays a popup dialog box that allows the user
to enter bounding box coordinates to zoom to (either rectangle or point)
EOT;

    }

    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams['TIMEOUT']))
        {
            $nSeconds = $this->maParams['TIMEOUT'];
        }
        else
            $nSeconds = 60 * 10;
        
        $this->mnTimeout = 1000 *  $nSeconds;
    }

    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();
        
        $aReturn['Timeout'.$this->mnId] = 'window.setTimeout( "KeepSessionAlive_'.$this->mnId.'()", '. $this->mnTimeout .');'."\n" ;
    
        return $aReturn;
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        $szImageName = 'KeepSessionAliveImage_'.$this->mnId;
        $nTimeout = $this->mnTimeout;
        $szURL = $_SESSION['gszCoreWebPath'].'/widgets/KeepSessionAlive/KeepSessionAlive.php?'.SID;
        $szJsFunctionName = 'KeepSessionAlive_'.$this->mnId;
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * refresh hidden image to prevent session timeouts
 */
function {$szJsFunctionName}()
{
    //copy of cwc_dhtml.js to keep lightweight
    var CWCIsNav4 = (document.layers) ? 1:0;
    var CWCIsIE = (document.all) ? 1:0;
    var CWCIsNav6 = (document.getElementById && !document.all) ? 1:0;var obj = null;
    var szImage = "{$szImageName}";
    if (CWCIsNav4) //Netscape 4.x
    {
        obj = document.images[szImage];
    }
    else
    {
        obj = document.getElementById(szImage);
    }
    if (obj != null)
    {
        obj.src = "{$szURL}" + "&rand=" + Math.random();
    }
    window.status = "last update: " + Date();
    window.setTimeout( "{$szJsFunctionName}()", {$nTimeout} );
    return true;
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        $szResult = '<img name="KeepSessionAliveImage_'.$this->mnId.'" id="KeepSessionAliveImage_'.$this->mnId.'" src="'.$_SESSION['gszCoreWebPath'].'/widgets/KeepSessionAlive/KeepSessionAlive.php?'.SID.'" border="0" width="1" height="1">';
        return $szResult;
    }
}
?>
