<?php
/**
 * GpsUtil Widget class
 *
 * @project     CWC2
 * @revision    $Id: GpsUtil.widget.php,v 1.1 2004/05/27 15:11:08 yassefa Exp $
 * @purpose     GPS utility widget
 * @author      DM Solutions Group (yassefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once (dirname(__FILE__)."/../Button.php");
include_once (dirname(__FILE__)."/../Popup.php");
include_once (dirname(__FILE__)."/../Label.php");


define("GPS_LAYER_NAME", "tmp_gps_layer");
/**
 * GpsUtil
 *
 * @desc GpsUtil widget class
 */
class GpsUtil extends CWCWidget
{
     var $moButton;
     var $moPopup;
     var $moLabel;
    
     function GpsUtil()
     {
         // invoke constructor of parent
         parent::CWCWidget();

         $this->mnPriority = PRIORITY_HIGH;

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The GpsUtil widget provides a dialog box that can be used to startup a gps
and render points on a map.
EOT;

        $this->moButton = new CWCButton($this);
        $this->moLabel = new CWCLabel( $this );

        $this->moPopup = new CWCPopup ($this);

        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."widgets/GpsUtil/GpsPopup.phtml";
        $this->moPopup->mszParam = "&szCallbackFunc=GpsUtilCB";

        //define the attributes for the widget
        $this->maAttributes["GPSURL"] = new StringAttribute( "GPSURL", true);
        $this->maAttributes["PORT"] = new StringAttribute( "PORT", true);
        $this->maAttributes["BAUD"] = new IntegerAttribute( "BAUD", true);
        $this->maAttributes["DATABITS"] = new IntegerAttribute( "DATABITS", true);
        $this->maAttributes["STOPBITS"] = new FloatAttribute( "STOPBITS", true);
        $this->maAttributes["PARITY"] = new StringAttribute( "PARITY", true);
        $this->maAttributes["DEBUG"] = new IntegerAttribute( "DEBUG", false);
        $this->maAttributes["GPSBINARY"] = new StringAttribute( "GPSBINARY", false);
        
     }

     function InitDefaults()
    {
        parent::InitDefaults();
        
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('clickGpsPopup');
    }

         /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        $aReturn = $this->moButton->GetJavascriptFunctions();//array();
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."widgets/GpsUtil/GpsPopup.phtml?"."PORT=".$this->maParams["PORT"].
          "&BAUD=".$this->maParams["BAUD"]."&DATABITS=".$this->maParams["DATABITS"]."&STOPBITS=".$this->maParams["STOPBITS"]."&PARITY=".$this->maParams["PARITY"]."&GPSURL=".urlencode($this->maParams["GPSURL"]);
        if (isset($this->maParams["DEBUG"]) && 
            (strcasecmp($this->maParams["DEBUG"], "true") == 0 ||
             $this->maParams["DEBUG"] ==1))
          $this->moPopup->mszLink .= "&DEBUG=1";
        //echo $this->maParams["GPSBINARY"];
        if (isset($this->maParams["GPSBINARY"]))
          $this->moPopup->mszLink .= "&GPSBINARY=".urlencode($this->maParams["GPSBINARY"]);

        //echo  $this->moPopup->mszLink;
        $szJsFunctionName = "clickGpsPopup";
        $szButtonJS = $this->moPopup->DrawPublish();
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a GPS Box dialog
 */
function {$szJsFunctionName}()
{
    {$szButtonJS}
    return;
}
EOT;
     $aReturn[$szJsFunctionName] = $szFunction; 

     $szJsFunctionName = "GpsUtilCB";
     $szFunction = <<<EOT
function {$szJsFunctionName}(actionID, wh)
{

  if (actionID == 1) //refresh map
  {    
      //alert('refresh map');
      //alert(wh.gsLatLongCoordinates);
      //if there are coordinates set, set the hidden variable
      //and submit the page.
      
      if ({$this->mszHTMLForm}.GPSUTIL_LATLONG_STRING != null)
      {
          {$this->mszHTMLForm}.GPSUTIL_LATLONG_STRING.value = wh.gsLatLongCoordinates;
          {$this->mszHTMLForm}.GPSUTIL_PLOT_TYPE.value = wh.gsPlotPointType;
          {$this->mszHTMLForm}.GPSUTIL_SYMBOL_NAME.value = wh.gsSymbol;
          {$this->mszHTMLForm}.GPSUTIL_SYMBOL_SIZE.value = wh.gsSymbolSize;
          {$this->mszHTMLForm}.GPSUTIL_SYMBOL_COLOR.value = wh.gsSymbolColor;
          {$this->mszHTMLForm}.GPSUTIL_SYMBOL_OUTLINECOLOR.value = wh.gsSymbolOutlineColor;
      
          if ({$bCWCJSAPI})
          {
              goCWCJSAPI.oMap.GPSUtilWidget(wh.gsLatLongCoordinates,
                                             wh.gsPlotPointType, 
                                            wh.gsSymbol,
                                             wh.gsSymbolSize,
                                             wh.gsSymbolColor,
                                             wh.gsSymbolOutlineColor);
          }
          else
          {
              {$this->mszHTMLForm}.submit();
          }
      }
  
  
      
  }
  if (actionID == 2) //cancel
  {     
      alert('cancel map');
  }
  return;
}
EOT;
 
     $aReturn[$szJsFunctionName] = $szFunction;

     return $aReturn;
    }
 
     /**
     * GetHTMLHiddenVariables
     *
     * Return HTML hidden variables.
     */
    function GetHTMLHiddenVariables ()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        $szVariable = "GPSUTIL_LATLONG_STRING";
        $szVal = "";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "GPSUTIL_PLOT_TYPE";
        $szVal = "";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;
        
        $szVariable = "GPSUTIL_SYMBOL_NAME";
        $szVal = "";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "GPSUTIL_SYMBOL_SIZE";
        $szVal = "";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "GPSUTIL_SYMBOL_COLOR";
        $szVal = "";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "GPSUTIL_SYMBOL_OUTLINECOLOR";
        $szVal = "";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szVal\">\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }
        
     /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- GPS popup widget hidden -->";
        
        $szResult = $this->moButton->DrawPublish();

        $szResult = $this->moLabel->DrawPublish( $szResult );
        return $szResult;
    }

    /**
     * ParseURL
     *
     * Look for the extents in the URL and set the map.
     */
    function ParseURL ()
    {
        $szLayerName = GPS_LAYER_NAME;
        if (isset($this->moURLArray["GPSUTIL_LATLONG_STRING"]) &&
            strlen($this->moURLArray["GPSUTIL_LATLONG_STRING"]) > 0 &&
            isset($this->moURLArray["GPSUTIL_PLOT_TYPE"]))
        {
          /*
            echo "lat/long = " . $this->moURLArray["GPSUTIL_LATLONG_STRING"] . "<br>\n";
          echo "plot type " . $this->moURLArray["GPSUTIL_PLOT_TYPE"] . "<br>\n";
          echo "name " .  $this->moURLArray["GPSUTIL_SYMBOL_NAME"] . "<br>\n";
          echo "siez= " .  $this->moURLArray["GPSUTIL_SYMBOL_SIZE"] . "<br>\n";
          echo "color= " .  $this->moURLArray["GPSUTIL_SYMBOL_COLOR"] . "<br>\n";
          echo "outlinecolor= " .  $this->moURLArray["GPSUTIL_SYMBOL_OUTLINECOLOR"] . "<br>\n";
          */
            $oMap = $this->moMapObject->getMapObj();

            //echo $this->moURLArray["GPSUTIL_LATLONG_STRING"];
/* -------------------------------------------------------------------- */
/*      Check if the gps tmp layer is already created. If not create    */
/*      the layer and shape file (and dbf).                             */
/* -------------------------------------------------------------------- */
            $oLayer = false;
            $aszLayerName = $oMap->getAllLayerNames();
            foreach ($aszLayerName as $szKey => $szTmp)
              if ($szTmp == $szLayerName)
                $oLayer = $oMap->getlayer($szKey);
            if ($oLayer === false)
            {
                $oLayer = ms_newLayerObj( $oMap );
                $oLayer->set( "name", $szLayerName);
                $oLayer->set( "type", MS_LAYER_POINT );
                $oLayer->set( "status", MS_ON );
                //$oLayer->set( "units", MS_DD);
                $szData = $_SESSION['gszTmpPath'].session_id();// . uniqid("");
                $oLayer->set( "data",  $szData);
                //$oLayer->set("classitem", "id" );
                $oLayer->setprojection("init=epsg:4326");
            }
/* -------------------------------------------------------------------- */
/*      create a class and a style.                                     */
/* -------------------------------------------------------------------- */
            if ($oLayer->numclasses == 0)
              ms_newclassObj($oLayer);
            $oClass = $oLayer->getclass(0);
            if ($oClass->numstyles == 0)
              ms_newStyleObj($oClass);
            $oStyle = $oClass->getstyle(0);
            $oStyle->set("symbolname", $this->moURLArray["GPSUTIL_SYMBOL_NAME"]);
            $oStyle->set("size", $this->moURLArray["GPSUTIL_SYMBOL_SIZE"]);
            $aColors = split(",", $this->moURLArray["GPSUTIL_SYMBOL_COLOR"]);
            if (count($aColors) == 3)
              $oStyle->color->setRGB($aColors[0],$aColors[1], $aColors[2]);
            else
              $oStyle->color->setRGB(255,0,0);
                
            $aColors = split(",", $this->moURLArray["GPSUTIL_SYMBOL_OUTLINECOLOR"]);
            if (count($aColors) == 3)
              $oStyle->outlinecolor->setRGB($aColors[0],$aColors[1], $aColors[2]);
            else
              $oStyle->outlinecolor->setRGB(0,0,0);
                
            
            //create new files if they do not exist or the user selected
            //the option to plot only the last points.
            if (!file_exists($oLayer->data.".dbf") ||
                (isset($this->moURLArray["GPSUTIL_PLOT_TYPE"]) && 
                 $this->moURLArray["GPSUTIL_PLOT_TYPE"] == 2))
            {
                // create the temp shapefile files
                $shpFname = $oLayer->data;

                $shpFile = ms_newShapeFileObj( $shpFname, MS_SHP_POINT );
                //$aDbfStruct =   array(array("time", "N", 10, 0));
                $aDbfStruct =   array(array("lon", "N", 10, 6),
                                      array("lat", "N", 10, 6),
                                      array("time", "N", 10, 0));
                // create the dbase file
                $dbfFile = dbase_create( $shpFname.".dbf", $aDbfStruct);
                // close the dbf
                dbase_close( $dbfFile );
                // release resources
                $shpFile->free();
            }
/* -------------------------------------------------------------------- */
/*      Parse the latlong string to extract the values and add them.    */
/* -------------------------------------------------------------------- */
            $aLatLongList = 
              split (";",$this->moURLArray["GPSUTIL_LATLONG_STRING"]);
            $nCount=count($aLatLongList);
            if ( $nCount <= 0)
              return;
            
            
            $shpFname = $oLayer->data;
            $shpFile = ms_newShapeFileObj( $shpFname, -2);
            $dbfFile = dbase_open($oLayer->data.".dbf", 2);
            //echo $this->moURLArray["GPSUTIL_LATLONG_STRING"] .  "ncount = $nCount <br>\n";

            //$nCount-1 because there is a ; at the end of the string 
            //Lat=45.401512,Long=-75.726022,1083103581;Lat=45.401508,Long=-75.726018,1083103591;
            for ($i=0; $i<$nCount-1; $i++)
            {
                $aLatLong = split(",", $aLatLongList[$i]);
                if (count($aLatLong) == 3)
                {
                    $aLatValue = split("=",$aLatLong[0]);
                    $dfLat = $aLatValue[1];

                    $aLongValue = split("=",$aLatLong[1]);
                    $dfLong = $aLongValue[1];

                    $nTime = $aLatLong[2];

                    
                    $oPoint = ms_newPointObj();
                    //$dfLat= 45.401622; //points at 30 rosemount
                    //$dfLong = -75.725790;
                    $oPoint->setXY($dfLong, $dfLat);
                    //$projin = ms_newprojectionobj("init=epsg:4326");
                    //$projout = ms_newprojectionobj("init=epsg:32189");
                    
                    //$oPoint->project($projin, $projout);
                    //$tttx = $oPoint->x;
                    //$ttty = $oPoint->y;
                    
                    //echo "prjected point x=$tttx, y=$ttty, time=$nTime <br>\n";
                    
                    $oShp = ms_newShapeObj(MS_SHP_POINT);
                    $oLine = ms_newLineObj();
                    $oLine->addXY($dfLong, $dfLat);

                    $oShp->add( $oLine );
                    $shpFile->addShape($oShp);
                    //echo "records before add : " . dbase_numrecords ($dbfFile) . "<br>\n";
                    //echo "adding point lat=$dfLat, long=$dfLong, time=$nTime <br>\n";
                    dbase_add_record($dbfFile, array($dfLong, $dfLat,$nTime));
                    
                    //echo "records after add : " . dbase_numrecords ($dbfFile) . "<br>\n";
                    
                }
            }
        

            if ($dbfFile)
              dbase_close($dbfFile);
            $shpFile->free();

            $oMap->save("c:/msapps/gpstest/map/ttt.map");
        }

         // return success
        return true;
    }

}
