<?php
/**
 * ExtractContext Widget class
 *
 * @project     CWC2
 * @revision    $Id: ExtractContext.widget.php,v 1.5 2004/07/08 17:49:07 pspencer Exp $
 * @purpose     ExtractContext widget class
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */


include_once(dirname(__FILE__)."/../Widget.php");
include_once( COMMON."wrapper/map_navigator.php" );
include_once(dirname(__FILE__)."/../Popup.php");
include_once(dirname(__FILE__)."/../Button.php");

/**
 * ExtractContext
 *
 * Extract widget class
 */
class ExtractContext extends CWCWidget
{
    var $moPopup;          // Popup object\
    var $moButton;

    /**
     * ExtractContextWidget
     *
     * Constctor method for the ExtractContext widget.
     */
    function ExtractContext()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/ExtractContext.dbf";

        // invoke constructor of parent
        parent::CWCWidget();

        $this->moPopup = new CWCPopup( $this );
        $this->moButton = new CWCButton( $this );
        
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ExtractContext widget passes the current context to a web-based extraction
service.
EOT;

        $this->maAttributes["EXTRACTURL"] = new StringAttribute( "EXTRACTURL", true );        
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moPopup->InitDefaults();
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('clickExtractContext');
    }

    function ParseURL()
    {
        return $this->moButton->ParseURL();
    }


    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = $this->moButton->GetJavascriptFunctions();

        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/ExtractContext/ExtractContext.phtml";
        $this->moPopup->mszParam = "&EXTRACTURL=".urlencode($this->maParams["EXTRACTURL"]);
        $szPopup = $this->moPopup->DrawPublish();

        $szJsFunctionName = "clickExtractContext";
        $szFunction = "function $szJsFunctionName()\n" .
         "{\n".
          $szPopup."\n".
        "return;\n" .
        "}\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }
    
    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }
    
    function GetHTMLHiddenVariables()
    {
        return $this->moButton->GetHTMLHiddenVariables();
    }


    /**
     * DrawPublish
     *
     * Return the HTML code to display the link to the legend popup
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- ExtractContext widget hidden -->";

        $szReturn = $this->moButton->DrawPublish();

        return $szReturn;
    }
}
?>
