<?php
/**
 * Extract Widget class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     Extract Popup Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Link/Link.widget.php");
include_once( COMMON."wrapper/map_navigator.php" );

/**
 * Extract
 *
 * Extract widget class
 */
class Extract extends Link
{

    /**
     * Extract
     *
     * Constctor method for the Extract widget.
     */
    function Extract()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/Extract.dbf";

        // invoke constructor of parent
        parent::Link();

        $this->Link($this);
        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The Extract widget is specific to GeoBase.  It connects the user to an
extraction service that allows for the extraction of visible layers at the
current extents.
EOT;

        $this->maAttributes["MINSCALE"] = new IntegerAttribute( "MINSCALE", false );
        $this->maAttributes["MAXSCALE"] = new IntegerAttribute( "MAXSCALE", false );
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {

      if (!is_object($this->moMapObject))
      {
          $aReturn = array( "doExtract" => "function doExtract(){ ; }" );
          return $aReturn;

      }
      $oMap = $this->moMapObject->oMap;

      $aszLayerName = array( "UNKNOW1" => "CAB1",
                             "CDED"    => "CDED1",
                             "UNKNOW2" => "CBN1",
                             "PVBM"    => "PVBM1",
                             "UNKNOW3" => "FED3D1",
                             "UNKNOW4" => "FED2D1",
                             "Landsat 7 Orthorectified Imagery" => "LANDSAT7",
                             "Road Segment" => "CNRN1",
                             "UNKNOW5" => "CT1");
        $aReturn = array( "doExtract" => "function doExtract(){ ; }" );

    if (!isset($_SESSION['gszCurrentLanguage']) && isset($_SESSION["gErrorManager"]))
    {
        $_SESSION['gErrorManager']->setError(ERR_WARNING,
               trim($this->moMLT->get("0", "ERROR: Language is not set in Extract.php.")));
    }
    else if (!isset($_SESSION['sessionid']) && isset($_SESSION["gErrorManager"]))
    {
        $_SESSION['gErrorManager']->setError(ERR_WARNING,
               trim($this->moMLT->get("1", "ERROR: sessionid is not set in Extract.php.")));
    }
    else
    {
        if (isset($_SESSION['gszCurrentLanguage']))
            $nLang = (($_SESSION['gszCurrentLanguage'] == "fr-CA") ? "2" : "1");
        else
            $nLang = 1;


        $aszExtents = array($oMap->extent->minx,
                            $oMap->extent->miny,
                            $oMap->extent->maxx,
                            $oMap->extent->maxy);

        $aszExtents = reprojectExtentFromCenter($aszExtents, $oMap->width, $oMap->height, $oMap->getProjection(), "init=epsg:4269");

        $szLayerNames = "";
        // loop through layers
        for($i=0; $i < count($this->moMapObject->oMap->getlayersdrawingorder()); $i++)
        {
            $oLayer = $this->moMapObject->oMap->getLayer($i);

        if (isset($aszLayerName[$oLayer->getMetadata("wms_title")]) &&
        $oLayer->status != MS_OFF)
                $szLayerNames .= $aszLayerName[$oLayer->getMetadata("wms_title")].":";
        }
        $szLayerNames = substr($szLayerNames, 0, -1);

        $szJsFunctionName = "doExtract";
        $szFunction = "function $szJsFunctionName()\n" .
          "{\n".
          "var servlet = 'http://www.geobase.ca/geobase/servlet/Geobase';\n".
          "var sessionid = '".$_SESSION['sessionid']."';\n".
          "var siteid = '51';\n".
          "var pageid = '$nLang-002-005-001';\n".
          "var srs = 'epsg:4269';\n".
          "var bbox = '".$aszExtents[0].",".
          $aszExtents[1].",".
          $aszExtents[2].",".
          $aszExtents[3]."';\n".
          "var layers = '".$szLayerNames."';\n".
          "window.open(servlet+'?sessionid='+sessionid+'&site_id='+siteid+'&page_id='+pageid+'&srs='+srs+'&bbox='+bbox+'&layers='+layers, 'extract');\n".
          "return;\n" .
          "}\n";

        $aReturn[$szJsFunctionName] = $szFunction;
    }

    return $aReturn;
    }


    /**
     * DrawPublish
     *
     * Return the HTML code to display the link to the legend popup
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- Extent widget hidden -->";

        $nMin = $this->GetValue("MINSCALE", 0);
        $nMax = $this->GetValue("MAXSCALE", 0);

        if (($nMin != $nMax) &&
            ($this->moMapObject->oMap->scale < $nMin ||
             $this->moMapObject->oMap->scale > $nMax))
        {
            $this->maParams["JSFUNCTION"] = "alert";
            $this->maParams["JSPARAMS"] = trim($this->moMLT->get("2", "Scale out of bounds."));
            $this->maParams["POPUP"] = "false";
            $this->moButton->SetOnClick($this->maParams["JSFUNCTION"], 
                                        $this->maParams["JSPARAMS"]);
        }
        else
        {
            if (!is_object($this->moMapObject))
            {
                $this->maParams["JSFUNCTION"] = "void";
            }
            else
            {
                $this->maParams["JSFUNCTION"] = "doExtract";
            }
            $this->maParams["JSPARAMS"] = "";
            $this->maParams["POPUP"] = "true";
            $this->moButton->SetOnClick($this->maParams["JSFUNCTION"], 
                                        $this->maParams["JSPARAMS"]);
        }

        $szReturn = parent::DrawPublish();

        return $szReturn;
    }
}
?>
