<?php
/**
 * ErrorReport Widget class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     ErrorReport Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * ErrorReport
 *
 * @desc ErrorReport widget class
 */
class ErrorReport extends CWCWidget
{
    var $moButton;
    var $moPopup;          /// Popup object

    /**
     * ErrorReport
     *
     * Constctor method for the ErrorReport widget.
     */
    function ErrorReport()
    {
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
This is a utility widget used to display errors that have occurred during
processing.  Normally the errors are non-fatal, but could be useful in
debugging widgets or a new template.
EOT;

        $this->mnPriority = PRIORITY_LAST;

        $this->moPopup = new CWCPopup($this);
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/ErrorReport/ErrorReportPopup.phtml";
        $this->moButton = new CWCButton($this);
    }

    /**
     * initialize default values from tag
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";

        if ($this->mbVisible)
        {
            $this->moButton->InitDefaults();
            $this->moButton->SetOnClick( "DisplayErrors" );
        }
    }
    
    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();

        if ($this->mbVisible)
            $this->moPopup->mszParam .= "&bOpenedManualy=1";

        $szJsFunctionName = "DisplayErrors";
        $szFunction = "function $szJsFunctionName()\n" .
        "{\n".
          $this->moPopup->DrawPublish()."\n".
        "return;\n" .
        "}\n";

        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetJavascriptOnLoadFunctions
     *
     * Should be redefined for Widgets returning Javascript code.
     *
     * @returns An empty  string.
     */
    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
                    $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
                else
            $aReturn = array();
            
        if ($_SESSION['gErrorManager']->nErrorCount > 0)
        {
            $szJsFunctionName = "DisplayErrors";
            $szFunction = "$szJsFunctionName();\n";
            $aReturn[$szJsFunctionName] = $szFunction;
        }

        return $aReturn;
    }

    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code to display the link to the legend popup
     */
    function DrawPublish()
    {
        $szReturn = "";

        //this would normally be done by Popup.php in it's draw publish.
        $this->moPopup->SetStyleResource();

        if (!$this->mbVisible)
        {
            return "<!-- ErrorReport widget hidden -->";
        }
        
        $szReturn = $this->moButton->DrawPublish();

        return $szReturn;
    }
}
?>
