<?php
/**
 * SLDDownload Widget class
 *
 * @project     CWC2
 * @revision    $Id: DownloadSLD.widget.php,v 1.5 2004/07/08 17:49:07 pspencer Exp $
 * @purpose     SLDDownload Popup Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");
include_once(dirname(__FILE__)."/../Label.php");

/**
 * SLDDownload
 *
 * @desc SLDDownload widget class
 */
class DownloadSLD extends CWCWidget
{
    var $mszTemplate;      // [string]

    var $moButton;         // Button object
    var $moPopup;          // Popup object

    var $mbSingleLayer = "false"; //whether to export a selected layer or
                                  //or entire map.
    /**
     * SLDDownload
     *
     * Constctor method for the SLDDownload widget.
     */
    function DownloadSLD()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The SLDDownloadWidget allows the user to download the current layers or layer of
the map as an SLD document.
EOT;
        $this->maAttributes["singlelayer"] = new BooleanAttribute( "singlelayer", false );

        $this->moLabel = new CWCLabel($this);

        $this->moButton = new CWCButton($this);
        $this->moPopup = new CWCPopup($this);
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/DownloadSLD/DownloadSLD.phtml";
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick("clickSLDDownload");
        if (isset($this->maParams["singlelayer"]))
            $this->mbSingleLayer =
                $this->maParams["singlelayer"];
    }

    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }
    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maAttributes['singlelayer']) &&
            $this->isVarSet('nlayerindex'))
        {
            $this->moPopup->mszParam .= "&szlayerindex=".
                  $this->getVar('nlayerindex');
        }

        $aReturn = array();

        $szJsFunctionName = "clickSLDDownload";
        $szFunction = "function $szJsFunctionName()\n" .
         "{\n".
          $this->moPopup->DrawPublish()."\n".
        "return;\n" .
        "}\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }
    
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
        
        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code to display the link to the legend popup
     */
    function DrawPublish()
    {
        
        $szReturn = $this->moButton->DrawPublish(  );

        return $szReturn;
    }
}

if ((function_exists( "RegisterWidget" )))
    RegisterWidget( "DownloadSLD", "DownloadSLD" );
?>
