<?php
/**
 * ContextDownload Widget class
 *
 * @project     CWC2
 * @revision    $Id:
 * @purpose     ContextDownload Popup Widget class
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");
include_once(dirname(__FILE__)."/../Label.php");

/**
 * ContextDownload
 *
 * @desc ContextDownload widget class
 */
class DownloadContext extends CWCWidget
{
    var $mszTemplate;      // [string]

    var $moButton;         // Button object
    var $moPopup;          // Popup object

    var $mszImagePath = "images/icon_txt_save_map.gif";
    var $mszImageSelectedPath = "images/icon_txt_save_map.gif";
    var $mszImageHoverPath = "images/icon_txt_save_map.gif";
    var $mszImageTip = "Save the current context";

    /**
     * ContextDownload
     *
     * Constctor method for the ContextDownload widget.
     */
    function DownloadContext()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ContextDownloadWidget allows the user to download the current state of
the map as a Context document.  Window size, current extents, and layer visibility
are preserved.
EOT;

        $this->moLabel = new CWCLabel($this);

        $this->moButton = new CWCButton($this);
        $this->moPopup = new CWCPopup($this);
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/DownloadContext/DownloadContext.phtml";
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick("clickContextDownload");
    }

    function GetJavascriptVariables()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptVariables();
        else return array();
    }

    function GetJavascriptInitFunctions()
    {
        if ($this->mbVisible)
            return $this->moButton->GetJavascriptInitFunctions();
        else return array();
    }

    function GetJavascriptOnLoadFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptOnLoadFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }

    function GetJavascriptIncludeFunctions()
    {
        if ($this->mbVisible)
            $aReturn = $this->moButton->GetJavascriptIncludeFunctions();
        else
            $aReturn = array();
        return $aReturn;
    }
    
    function GetHTMLHiddenVariables()
    {
        $aReturn = $this->moButton->GetHTMLHiddenVariables();
                
        return $aReturn;
    }
    
    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        if (isset($this->maszContents["VERSION"]))
        {
            $aszVersion = array();
            foreach ($this->maszContents["VERSION"] as $aVersion)
            {
                if (isset($aVersion["VALUE"]))
                    array_push($aszVersion, $aVersion["VALUE"]);
            }

            if (count($aszVersion) > 0)
                $this->moPopup->mszParam .= "&szValidVersion=".
                  urlencode(implode("|", $aszVersion));
        }

        $aReturn = array();

        $szJsFunctionName = "clickContextDownload";
        $szFunction = "function $szJsFunctionName()\n" .
         "{\n".
          $this->moPopup->DrawPublish()."\n".
        "return;\n" .
        "}\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * DrawPublish
     *
     * Return the HTML code to display the link to the legend popup
     */
    function DrawPublish()
    {
        $szReturn = $this->moButton->DrawPublish(  );

        return $szReturn;
    }
}
?>
