<?php
/**
 * DDSGUI Widget class
 *
 * @project     CWC2
 * @revision    $Id: DDSGUI.widget.php,v 1.6 2004/07/08 17:49:07 pspencer Exp $
 * @purpose     DDSGUI Popup Widget class
 * @author      DM Solutions Group (jlacroix@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2004, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");
include_once(dirname(__FILE__)."/../Button.php");
include_once(dirname(__FILE__)."/../Popup.php");

/**
 * DDSGUI
 *
 * DDSGUI widget class
 */
class DDSGUI extends CWCWidget
{
    var $szDDSGUIURL = "";
    var $moLabel;
    var $moButton;
    var $moPopup;

    /**
     * DDSGUI
     *
     * Constctor method for the DDSGUI widget.
     */
    function DDSGUI()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/DDSGUI.dbf";

        // invoke constructor of parent
        parent::CWCWidget();

        $this->moLabel = new CWCLabel( $this );
        $this->moButton = new CWCButton( $this );
        $this->moPopup = new CWCPopup( $this );
        $this->moPopup->mszLink = $_SESSION['gszCoreWebPath']."/widgets/DDSGUI/DDSGUI.phtml";

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The DDSGUI widget is is used to get the GUI popup of a MainDDS server. It is
used in conjonction with the ExtractWFSData widget. Note that the 
OriginServerURI and OriginServerField are taken from the layer metadatas. The 
two needed metadatas are called dds_originserveruri and dds_originserverfield.
EOT;

        $this->maAttributes["DDSGUIURL"] = new StringAttribute( "DDSGUIURL", 
                                                                 true );
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        //this widget should never belong to a toolset
        $this->maParams["TOOLSET"] = "";
        if(isset($this->maParams["DDSGUIURL"]))
            $this->szDDSGUIURL = $this->maParams["DDSGUIURL"];

        $this->moButton->InitDefaults();
        $this->moButton->SetOnClick('clickDDSGUI');
    }

    function GetJavascriptInitFunctions()
    {
        return $this->moButton->GetJavascriptInitFunctions();
    }

    function GetJavascriptVariables()
    {
        return $this->moButton->GetJavascriptVariables();
    }

    function GetJavascriptOnLoadFunctions()
    {
        return $this->moButton->GetJavascriptOnLoadFunctions();
    }

    function GetJavascriptIncludeFunctions()
    {
        return $this->moButton->GetJavascriptIncludeFunctions();
    }

    /**
     * GetHTMLHiddenVariables
     */
    function GetHTMLHiddenVariables()
    {
        // initialize return array
        $aReturn = $this->moButton->GetHTMLHiddenVariables();

        // setup the variables
        $szVariable = 'REQUEST_BODY';
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">\n";
        $aReturn[$szVariable] = $szValue;
        
        // return array of hidden variables    
        return $aReturn;
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        if (!isset($this->maSharedResourceWidgets['expressionbuilderresults']->maszContents['RESULT']) || 
            $this->maSharedResourceWidgets['expressionbuilderresults']->maszContents['RESULT'] == "")
        {
            $szJsFunctionName = "clickDDSGUI";
            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * call the DDSGUI popup
 */
function {$szJsFunctionName}()
{
    alert('The DDSGUI can only be used in conjonction with the expression builder. Please build an expression before using this button.');
    return;
}
EOT;
        }
        else
        {
            // Set the request to the ddsgui
            $szRequest = "";

            $szLayerName = array_keys($this->maSharedResourceWidgets['expressionbuilderresults']->maszContents['RESULT']);
            $szLayerName = $szLayerName[0];
            $oLayer = $this->moMapObject->oMap->getLayerByName($szLayerName);
            $szServerURI = $oLayer->getMetadata("dds_originserveruri");
            $szServerField = $oLayer->getMetadata("dds_originserverfield");

            $szGeolinkIds = "";
            foreach($this->maSharedResourceWidgets['expressionbuilderresults']->maszContents['RESULT'][$szLayerName] as $aszRecord)
            {
              foreach($aszRecord as $aszAttribute)
              {
                if($aszAttribute["attribute"] == $szServerField)
                {
                    $szGeolinkIds .= "<I>".$aszAttribute["value"]."</I>";
                    break;
                }
              }
            }

            // Build the XML request
            $szRequest = "<?xml version='1.0' ?><DDSGUIRequest version='0.9.0'>   <OriginServerURI>$szServerURI</OriginServerURI>   <OriginServerField>$szServerField</OriginServerField>   <GeolinkIds>$szGeolinkIds</GeolinkIds> </DDSGUIRequest>";

            $aReturn = $this->moButton->GetJavascriptFunctions();//array();
            $szJsFunctionName = "clickDDSGUI";
            $szButtonJS = $this->moPopup->DrawPublish();
            $szPopupName = $this->moPopup->GetPopupName();
            $szPopupOption = $this->moPopup->GetPopupOptions();

            $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * popup a extract wfs data dialog
 */
function {$szJsFunctionName}()
{
    var wh = window.open('', '{$szPopupName}', '{$szPopupOption}');

    var szMethod;
    szMethod = {$this->mszHTMLForm}.method;
    {$this->mszHTMLForm}.method = 'POST';
    {$this->mszHTMLForm}.action = '{$this->szDDSGUIURL}';
    {$this->mszHTMLForm}.target = '{$szPopupName}';

    // Set the request to the ddsgui
    {$this->mszHTMLForm}.REQUEST_BODY.value = "$szRequest";

    {$this->mszHTMLForm}.submit();

    wh.focus();

    {$this->mszHTMLForm}.method = szMethod;
    {$this->mszHTMLForm}.action = '';
    {$this->mszHTMLForm}.target = '';

    return;
}
EOT;
        }

        $aReturn[$szJsFunctionName] = $szFunction;
        
        return $aReturn;
    }


    /**
     * DrawPublish
     *
     * Return the HTML code to display the DDSGUI widget
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- DDSGUI widget hidden -->";

        $szResult = $this->moButton->DrawPublish();
        $szResult = $this->moLabel->DrawPublish( $szResult );
        return $szResult;
    }
}
?>
