<?php
/**
 * Cursor postion display widget
 *
 * @project     CWC2
 * @revision    $Id: Cursorpos.widget.php,v 1.4 2004/07/08 15:58:57 pspencer Exp $
 * @purpose     Base Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../Widget.php");
include_once(dirname(__FILE__)."/../Label.php");

/**
 * CursorPosWidget.
 *
 */
class CursorPos extends CWCWidget
{
    var $moLabel;
    var $mnDefaultTextFieldSize = 20;
    var $mszAxis = "X";
    var $mszClass = "CWCCursorPositionWidgetClass";
    var $mszStyle = "";

    function CursorPos()
    {
        // invoke constructor of parent
        parent::CWCWidget();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
Display the current cursor position in geographic coordinates.  To assist
template developers, this widget can be configured to display one of the
two axis of the cursor position.  The cursor position must be displayed in
an HTML element that can be updated, so an HTML INPUT box is used.  CSS can
be used to modify the appearance of the INPUT box to make it look nicer in
more modern browsers.
EOT;

        $this->moLabel = new CWCLabel( $this );
        $this->maAttributes["AXIS"] = new StringAttribute( "AXIS", true, array( "X", "Y" ) );
        $this->maAttributes["TEXTFIELDSIZE"] = new IntegerAttribute( "TEXTFIELDSIZE", false, 0 );
        $this->maAttributes["WIDGETCLASS"] = new StringAttribute( "WIDGETCLASS", false );
        $this->maAttributes["WIDGETSTYLE"] = new StringAttribute( "WIDGETSTYLE", false );
    }

    function InitDefaults()
    {
        parent::InitDefaults();
        if (isset($this->maParams["AXIS"]))
            $this->mszAxis = strtoupper($this->maParams["AXIS"]);
        if (isset($this->maParams["TEXTFIELDSIZE"]))
            $this->mnDefaultTextFieldSize = strtoupper($this->maParams["TEXTFIELDSIZE"]);
        if (isset($this->maParams["WIDGETCLASS"]))
            $this->mszClass = strtoupper($this->maParams["WIDGETCLASS"]);
        if (isset($this->maParams["WIDGETSTYLE"]))
            $this->mszStyle = strtoupper($this->maParams["WIDGETSTYLE"]);
    }

    /**
     * GetJavascriptFunctions
     *
     * Build and return the array of functions needed in the
     * widget.
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        if (isset($this->maSharedResourceWidgets["CWCJSAPI"]))
          $bCWCJSAPI = 1;
        else
          $bCWCJSAPI = 0;

        $axis = $this->mszAxis;

        $szJsFunctionName = "Cursor".$axis."MouseMoved";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called when the cursor moves for Cursor Postion widget.
 */
function {$szJsFunctionName}(e)
{

    //make sure that the forms varaibales are initialized.
    //It seems like that in IE, the mouse move may be called before.
    if ({$this->mszHTMLForm} == null ||
      {$this->mszHTMLForm}.MAP_CURSOR_POS_${axis} == null)
      return true;

    var nPixPos = {$this->mszHTMLForm}.MAP_CURSOR_POS_${axis}.value;

    var dfGeoMinX;
    var dfGeoMinY;
    var dfGeoMaxX;
    var dfGeoMaxY;
    var nMapWidth;
    var nMapHeight;

    if ({$bCWCJSAPI})
    {
        dfGeoMinX = goCWCJSAPI.oMap.minx;
        dfGeoMinY = goCWCJSAPI.oMap.miny;
        dfGeoMaxX = goCWCJSAPI.oMap.maxx;
        dfGeoMaxY = goCWCJSAPI.oMap.maxy;

        nMapWidth = goCWCJSAPI.oMap.width;
        nMapHeight = goCWCJSAPI.oMap.height;
    }
    else
    {
        dfGeoMinX = {$this->mszHTMLForm}.MAP_EXTENTS_MINX.value;
        dfGeoMinY = {$this->mszHTMLForm}.MAP_EXTENTS_MINY.value;
        dfGeoMaxX = {$this->mszHTMLForm}.MAP_EXTENTS_MAXX.value;
        dfGeoMaxY = {$this->mszHTMLForm}.MAP_EXTENTS_MAXY.value;

        nMapWidth = {$this->mszHTMLForm}.MAP_WIDTH.value;
        nMapHeight = {$this->mszHTMLForm}.MAP_HEIGHT.value;
    }
    if (nPixPos >=0)
    {
        if ("{$axis}" == "X")
          var dfGeoPos = WidgetPix2Geo(nPixPos, 0, nMapWidth, dfGeoMinX,
                                        dfGeoMaxX, 0);
        else
          var dfGeoPos = WidgetPix2Geo(nPixPos, 0, nMapHeight, dfGeoMinY,
                                        dfGeoMaxY, 1); //1 for inverse Y axe


      {$this->mszHTMLForm}.CursorPos_{$axis}.value = dfGeoPos;
    }
}
EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "WidgetPix2Geo";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * Utility function to convert from pixel to georef coordinates.
 * Used in Cursor Postion widget.
 */

function {$szJsFunctionName}(nPixPos, dfPixMin, dfPixMax, dfGeoMin, dfGeoMax, nInversePix)
{
    dfWidthGeo = dfGeoMax - dfGeoMin;
    dfWidthPix = dfPixMax - dfPixMin;

    dfPixToGeo = dfWidthGeo / dfWidthPix;

    if (Math.abs(dfPixToGeo) < 1)
        dNbDecimal = Math.abs(Math.log(dfPixToGeo))/Math.log(10)+1;
    else
        dNbDecimal = 0;

    if (nInversePix == 0)
    {
        dfDeltaPix = nPixPos - dfPixMin;
    }
    else
    {
        dfDeltaPix = dfPixMax - nPixPos;
    }

    dfDeltaGeo = dfDeltaPix * dfPixToGeo;

    dfPosGeo = new String(new Number(dfGeoMin) + new Number(dfDeltaGeo));
    aPosGeo = dfPosGeo.split(".");

    if (dNbDecimal > 0 && aPosGeo.length == 2)
    {
        dfPosGeo = aPosGeo[0]+"."+aPosGeo[1].substr(0, dNbDecimal);
    }
    else
    {
        dfPosGeo = aPosGeo[0];
    }

    szttt =  ""+"pixelpos = "+nPixPos+" result ="+dfPosGeo;
    //alert(szttt);
    return dfPosGeo;
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }

    /**
     * GetJavascriptOnMouseMoveFunctions
     *
     * Returns functions to be called on mouse mouve event.
     */
    function GetJavascriptOnMouseMoveFunctions()
    {
        $aReturn = array();
        $axis = $this->mszAxis;
        $szJsFunctionName = "Cursor".$axis."MouseMoved";
        $szFunction = "$szJsFunctionName(e);\n";
        $aReturn[$szJsFunctionName] = $szFunction;

        return $aReturn;
    }


    /**
     * DrawPublish
     *
     * Return the HTML code using the name in the map file and the
     * parameters of the CWC tag.
     */
    function DrawPublish()
    {
        if (!$this->mbVisible)
            return "<!-- CursorPosition widget hidden -->";

        $nSize = $this->mnDefaultTextFieldSize;
        if (isset($this->maParams["TextFieldSize"]))
            $nSize = strtoupper($this->maParams["TextFieldSize"]);

        $szClass = "";
        if ( strlen($this->mszClass) > 0 )
            $szClass = " CLASS=\"$this->mszClass\"";
        $szStyle = "";
        if ( strlen($this->mszStyle) > 0 )
            $szStyle = " STYLE=\"$this->mszStyle\"";
        $szContents="<input$szClass$szStyle type=\"text\" name=\"CursorPos_".
                    $this->mszAxis."\" id=\"CursorPos_".
                    $this->mszAxis."\" value=\"\"  size=\"$nSize\" readonly>";

        return $this->moLabel->DrawPublish( $szContents );
    }
}
?>
