<?php
/**
 * Context Selector
 *
 * @project     CWC2
 * @revision    $Id: ContextSelector.widget.php,v 1.3 2004/07/08 15:58:57 pspencer Exp $
 * @purpose     Context Selector
 * @author      DM Solutions Group (spencer@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

include_once(dirname(__FILE__)."/../Widget.php");
include_once("ThemeParser.php");
include_once( CHAMELEON_PATH."/TemplateProcessor.php" );
include_once(dirname(__FILE__)."/../Popup.php");

class ContextSelector extends CWCWidget
{
    var $mszContextFile= "";
    var $mszThemeFile= "";
    var $mszRendererFile = "";
    var $moThemeParser = "";
    var $moTemplateProcessor = "";
    var $maSelections = array();
    var $mszInputBase = "CWC2_CS";
    var $moPopup;          /// Popup object

    function ContextSelector()
    {
        $this->mszLanguageResource = str_replace("\\","/",dirname(__FILE__))."/ContextSelector.dbf";

        // invoke constructor of parent
        parent::CWCWidget();

        $this->moTemplateProcessor = new TemplateProcessor();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The ContextSelector widget provides generic layer control capabilities
for CWC2 applications.  The widget is controlled by a template file and a theme
file that describe how layers in the current context should be presented to the
user.
EOT;

        $this->mnPriority =  PRIORITY_MEDIUM;

        $this->moPopup = new CWCPopup($this);
    }

    /**
     * per-widget initialization to initialize default values from
     * attributes etc.
     */
    function InitDefaults()
    {
        parent::InitDefaults();
        $this->mszContextFile = $this->GetCurrentContext();

        //process selections from tag.
        if (isset($this->maszContents["SELECTION"]))
        {
            for($i=0; $i<count($this->maszContents["SELECTION"]); $i++)
            {
                $aSel = $this->maszContents["SELECTION"][$i];
                $aNewSel = array();

                $aNewSel["selection_name"] = ((isset($aSel["NAME"])) ? 
                                              $aSel["NAME"] : "");
                $aNewSel["selection_contextfile"]=(isset($aSel["CONTEXTFILE"])?
                                              $aSel["CONTEXTFILE"] : "");
                $aNewSel["selection_templatefile"]=((isset($aSel["TEMPLATE"]))?
                                              $aSel["TEMPLATE"] : "");
                $aNewSel["selection_rendererfile"]=
                    (isset($aSel["RENDERERFILE"]) ? $aSel["RENDERERFILE"] :"");
                $aNewSel["selection_themefile"]= ((isset($aSel["THEMEFILE"])) ?
                                              $aSel["THEMEFILE"] : "");
                $aNewSel["selection_url"] = "javascript:ContextSelected( '".$aNewSel["selection_templatefile"]."', '".$aNewSel["selection_contextfile"]."')";

                if (strcasecmp(basename($aNewSel["selection_contextfile"]), basename($this->mszContextFile)) == 0)
                {
                    $aNewSel["selection_selected"] = "true";
                    $this->mszRendererFile = $aNewSel["selection_rendererfile"];
                    $this->mszThemeFile = $aNewSel["selection_themefile"];
                }
                else
                {
                    $aNewSel["selection_selected"] = "false";
                }
                array_push( $this->maSelections, $aNewSel );
            }
        }

        if (strlen($this->mszContextFile) > 0 && strlen($this->mszThemeFile) > 0)
        {
            $this->moThemeParser =  new ThemeParser($this->mszThemeFile);
        }
        else
            $_SESSION["gErrorManager"]->setError( 0, trim($this->moMLT->get("0", "Fatal Error: Theme Selector widget cannot find a theme file for"))." ".$this->mszContextFile );
        if (!is_object($this->moThemeParser))
            echo "problem";
    }


    /**
     * GetJavascriptVariables
     *
     * Return JS global variables and global code.
     */
    function GetJavascriptVariables()
    {

        $aReturn = array();
        if (!is_object( $this->moThemeParser ))
        {
            $aReturn["gContextSelectorManager"] = "";
            return $aReturn;
        }

        $nThemes = $this->moThemeParser->GetNumberOfThemes();

        $szVariable = "gContextSelectorManager";
        $szValue = " var $szVariable = \"\";\n";
        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }

    /**
     * GetJavascriptOnloadFunctions()
     */
    function GetJavascriptOnLoadFunctions()
    {
        $aReturn = array();

        $szJsName = "ContextSelector_initialize";
        $szJs = "ContextSelector_initialize();";
        $aReturn[$szJsName] = $szJs;

        return $aReturn;
    }


    /**
     * GetJavascriptIncludeFunctions
     *
     *
     */
    function GetJavascriptIncludeFunctions()
    {
        $aReturn = array();

        $szJsIncludeName = $_SESSION["gszCoreWebPath"]."./widgets/js/cwc_cs.js";
        $szInclude = "<script language=\"JavaScript\" src=\"".$szJsIncludeName ."\"></script>";
        $aReturn[$szJsIncludeName] = $szInclude;

        return $aReturn;
    }


    /**
     * GetHTMLHiddenVariables
     *
     */
    function GetHTMLHiddenVariables()
    {
/* -------------------------------------------------------------------- */
/*       CONTEXTSELECTOR is used to see if it is the first       */
/*       time that the page loads so we don't setlayer on/off.          */
/* -------------------------------------------------------------------- */

        $szVariable = "CONTEXTSELECTOR";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"1\">";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "CONTEXT";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "TEMPLATE";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
        $aReturn[$szVariable] = $szValue;

        $szVariable = "CONTEXTSELECTOR_CONTEXT_CHANGED";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"\">";
        $aReturn[$szVariable] = $szValue;

        $szLayersOn = "";
        $szAllLayers = "";

        $oMap = $this->moMapObject->oMap;
        $nLayers = $oMap->numlayers;
        $szSep0 = "";
        $szSep1 = "";

        for ($i=0; $i<$nLayers; $i++)
        {
            $oLayer = $oMap->getLayer($i);

            // Only process WMS layers since some non-wms layers
            // shouldn't be turned off (for instance, Locate
            // widget use "temp_point" layer to manage points).
            if ($oLayer->connectiontype == MS_WMS)
            {
                $szName = $oLayer->getMetadata("WMS_NAME");
                if ($oLayer->status == MS_ON)
                {
                    $szLayersOn .= $szSep1 . $szName;
                    $szSep1 = "|";
                }
                $szAllLayers .= $szSep0 . $szName;
                $szSep0 = "|";
            }
        }

        //used to contain the name of the layers set to on
        $szVariable = "CONTEXTSELECTOR_LAYERS_ON";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szLayersOn\" size=100>";
        $aReturn[$szVariable] = $szValue;

        //used to contain the name of the layers set to on
        $szVariable = "CONTEXTSELECTOR_ALL_LAYERS";
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szAllLayers\" size=100>";
        $aReturn[$szVariable] = $szValue;

        //used to test if the template has changed
        $szVariable = "CONTEXTSELECTOR_TEMPLATE";
        $szTemplate = "";
        if (isset($_SESSION["gszTemplate"]))
            $szTemplate = $_SESSION["gszTemplate"];
        $szValue = "<INPUT TYPE=HIDDEN NAME=$szVariable VALUE=\"$szTemplate\">";
        $aReturn[$szVariable] = $szValue;


        $aReturn[$szVariable] = $szValue;

        return $aReturn;
    }


    /**
     * GetJavascriptFunctions
     *
     */
    function GetJavascriptFunctions()
    {
        $aReturn = array();
        $oMap = $this->moMapObject->oMap;

        $aszContextLayers = array();
        for ($i=0; $i<$oMap->numlayers; $i++)
        {
            $oLayer = $oMap->GetLayer( $i );
            $aszContextLayers[$oLayer->getmetadata("WMS_NAME")] = ($oLayer->status == MS_ON) ? true : false;
        }

        $szInit = "    gContextSelectorManager = new CWC2_CS_Manager();\n";
        $szInit .= "    gContextSelectorManager.form = ".$this->mszHTMLForm.";\n";

        foreach($this->moThemeParser->maThemes as $szThemeName => $aGroups)
        {
            $szInit .= "    oTheme = new CWC2_CS_Theme( \"".$szThemeName."\" );\n";
            $szInit .= "    gContextSelectorManager.AddTheme( oTheme );\n";

            $szType = $this->moThemeParser->GetThemeAttribute( $szThemeName, "theme_type" );

            $szInit .= "    oTheme.SetType( \"".$szType."\" );\n";

            $bThemeOn = ($szType == "checkbox");
            foreach ($aGroups as $szGroupName => $aLayersInGroup)
            {
                $szInit .= "    oGroup = new CWC2_CS_Group( \"".$szGroupName."\" );\n";
                if ($this->moThemeParser->GetGroupAttribute( $szThemeName, $szGroupName, "group_visible" ) == "false")
                {
                    $szInit .= "    oGroup.SetVisible( false );\n";
                }
                $szInit .= "    oTheme.AddGroup( oGroup );\n";
                $bOn = false;
                $nGroupLayers = 0;
                foreach( $aLayersInGroup as $szLayerName )
                {
                    if (array_key_exists( $szLayerName, $aszContextLayers ))
                    {
                        ++$nGroupLayers;

                        $szInit .= "    oGroup.AddLayer( new CWC2_CS_Layer( \"".$szLayerName."\" ) );\n";
                        $bOn |= $aszContextLayers[$szLayerName];
                    }
                }

                if ($szType == "checkbox" && $nGroupLayers > 0)
                    $bThemeOn &= $bOn;
                else
                    $bThemeOn |= $bOn;

                if ($bOn && $nGroupLayers > 0)
                    $szInit .= "    oGroup.SetStatus( true );\n";
                if ($nGroupLayers == 0)
                    $szInit .= "    oGroup.SetVisible( false );\n";
            }
            if ($bThemeOn)
                $szInit .= "    oTheme.SetStatus( true );\n";

        }

        //process the layers in the map file and see if they are all supported
        for ($i=0; $i<$oMap->numlayers; $i++)
        {
            $oLayer = $oMap->GetLayer( $i );
            //only process WMS layers so temp annotation layers aren't affected
            if ($oLayer->connectiontype == MS_WMS)
            {
                $szLayer = $oLayer->getMetaData( "WMS_NAME" );
                if (!array_key_exists( $szLayer, $this->moThemeParser->maLayers ) )
                {
                    if ($this->moThemeParser->maGlobals["gThemeExtendContext"] == "true")
                    {
                        $szInit .= "    oTheme = new CWC2_CS_Theme( \"".$szLayer."\" );\n";
                        $szInit .= "    gContextSelectorManager.AddTheme( oTheme );\n";
                        $szInit .= "    oTheme.SetType( 'checkbox' );\n";
                        $szInit .= "    oGroup = new CWC2_CS_Group( \"".$szLayer."\" );\n";
                        $szInit .= "    oTheme.AddGroup( oGroup );\n";
                        if ($this->moThemeParser->maGlobals["gThemeExtraLayers"] == "true")
                        {
                            $szInit .= "    oGroup.SetVisible( true );\n";
                        }
                        else
                        {
                            $szInit .= "    oGroup.SetVisible( false );\n";
                        }
                        $szInit .= "    oGroup.AddLayer( new CWC2_CS_Layer( \"".$szLayer."\" ) );\n";
                        if ($oLayer->status == MS_ON)
                            $szInit .= "    oTheme.SetStatus( true );\n";

                    }
                }
            }
        }

        $szInit .= "    gContextSelectorManager.UpdateStatus();\n";

        $szJsFunctionName = "ContextSelector_initialize";
        $szFunction = <<<EOT
/**
 * {$szJsFunctionName}
 * called during OnLoad event to initialize the Context Selector manager
 */
function {$szJsFunctionName}()
{
{$szInit};
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;


       $szJsFunctionName = "ContextSelector_openGroupInfo";
       $sCommon = COMMON;
       $sSID = SID;
       $szCoreWebPath = $_SESSION['gszCoreWebPath'];
       $szFunction = <<<EOT
/**
* {$szJsFunctionName}
* called when a Group is clicked in the ContextSelector widget
*/
function {$szJsFunctionName}(groupName, groupAbstract, groupLayers)
{
    var i;
    if (document.all)
        var xMax = screen.width, yMax = screen.height;
    else
        if (document.layers)
            var xMax = window.outerWidth, yMax = window.outerHeight;
        else
            var xMax = 640, yMax=480;

    var xOffset = (xMax - 550)/2, yOffset = (yMax - 580)/2;
    szBaseURL = "{$szCoreWebPath}widgets/ContextSelectorInfo.phtml?common={$sCommon}&{$sSID}&";
    szOptions = 'resizable=yes,scrollbars=yes,width=600,height=400,screenX='+
                xOffset+',screenY='+yOffset+',top='+yOffset+',left='+xOffset+'';

    //calculate the URL options
    szGroupLayers = "";
    szSep = "";
    for (i=0; i<groupLayers.length; i++)
    {
        szGroupLayers += szSep + groupLayers[i];
        szSep = ";";
    }
    szExtraURL = "";
    szExtraURL += "groups=" + groupName;
    szExtraURL += "&groups_abstracts=" + groupAbstract;
    szExtraURL += "&groups_layers=" + szGroupLayers;

    //alert( szExtraURL );
    layerinfo = window.open(szBaseURL + szExtraURL, "layer_info", szOptions);
    layerinfo.focus();
}

EOT;
        $aReturn[$szJsFunctionName] = $szFunction;


       $szJsFunctionName = "ContextSelector_openThemeInfo";
       $sCommon = COMMON;
       $sSID = SID;
       $szFunction = <<<EOT
/**
* {$szJsFunctionName}
* called when a Theme is clicked in the ContextSelector widget
*/
function {$szJsFunctionName}(themeName, themeAbstract, themeGroups)
{
    var i, j;
    if (document.all)
        var xMax = screen.width, yMax = screen.height;
    else
        if (document.layers)
            var xMax = window.outerWidth, yMax = window.outerHeight;
        else
            var xMax = 640, yMax=480;

    var xOffset = (xMax - 550)/2, yOffset = (yMax - 580)/2;
    var szBaseURL = "widgets/ContextSelectorInfo.phtml?common={$sCommon}&{$sSID}&";
    var szOptions = 'resizable=yes,scrollbars=yes,width=600,height=400,screenX='+xOffset+
                ',screenY='+yOffset+',top='+yOffset+',left='+xOffset+'';

    //calculate the URL options

    var szThemeLayers = "";
    var szThemeSep = "";
    var szGroups = "";
    var szGroupAbstracts = "";
    for (i=0; i<themeGroups.length; i++)
    {
        var szGroupLayers = "";
        var szGroupSep = "";
        var group = themeGroups[i];
        szGroups += szThemeSep + group[0];
        szGroupAbstracts += szThemeSep + group[1];
        groupLayers = group[2];
        for (j=0; j<groupLayers.length; j++)
        {
            szGroupLayers += szGroupSep + groupLayers[j];
            szGroupSep = ";";
        }

        szThemeLayers += szThemeSep + szGroupLayers;
        szThemeSep = "|";
    }
    var szExtraURL = "";
    szExtraURL += "theme=" + themeName;
    szExtraURL += "&theme_abstract=" + themeAbstract;
    szExtraURL += "&groups=" + szGroups;
    szExtraURL += "&groups_abstracts=" + szGroupAbstracts;
    szExtraURL += "&groups_layers=" + szThemeLayers;

    //alert( szExtraURL );
    layerinfo = window.open(szBaseURL + szExtraURL, "layer_info", szOptions );
    layerinfo.focus();
}

EOT;
        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "ContextSelector_SetThemeStatus";
        $szFunction = <<<EOT
/*
 * {$szJsFunctionName}
 */
function {$szJsFunctionName}( nTheme, bStatus )
{
    //alert( "set theme status for theme " + nTheme + " to " + bStatus );
    gContextSelectorManager.SetThemeStatus( nTheme, bStatus );
    {$this->mszHTMLForm}.CONTEXTSELECTOR_LAYERS_ON.value = gContextSelectorManager.GetVisibleLayerNames();
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "ContextSelector_SetGroupStatus";
        $szFunction = <<<EOT
/*
 * {$szJsFunctionName}
 */
function {$szJsFunctionName}( nTheme, nGroup, bStatus )
{
    //alert( "set group status for theme " + nTheme + ", group " + nGroup + " to " + bStatus );
    gContextSelectorManager.SetGroupStatus( nTheme, nGroup, bStatus );
    {$this->mszHTMLForm}.CONTEXTSELECTOR_LAYERS_ON.value = gContextSelectorManager.GetVisibleLayerNames();
}
EOT;

        $aReturn[$szJsFunctionName] = $szFunction;

        $szJsFunctionName = "ContextSelected";
        $szFunction = <<<EOT
/**
* {$szJsFunctionName}
* called when a conext is selected in ContextSelector widget
*/
function {$szJsFunctionName}(szTemplate, szContext)
{
        {$this->mszHTMLForm}.CONTEXT.value = szContext;
        {$this->mszHTMLForm}.TEMPLATE.value = szTemplate;
        {$this->mszHTMLForm}.CONTEXTSELECTOR_CONTEXT_CHANGED.value = "1";
        {$this->mszHTMLForm}.submit();
}
EOT;
       $aReturn[$szJsFunctionName] = $szFunction;


        return $aReturn;
    }



    /**
     * ParseURL
     *
     * Loop trough all layers and set them to on/off if found in
     * the URL.
     */
    function  ParseURL()
    {
         //handle unthemed layers
         //this is part of widget initialization but is done here because it needs
         //the map object.
         $this->moThemeParser->ProcessExtraLayers($this->moMapObject->oMap);

/* ==================================================================== */
/*      Check for GEOBASECONTEXTSELECTOR which is set the first time    */
/*      the widget is published.                                        */
/*      Check for GEOBASE_CONTEXT which is set by the                   */
/*      GeobaseUploadContext.widget.php. If this is set, we are         */
/*      loading a new context so ignore the set on/off layers.          */
/* ==================================================================== */
        if ($this->isVarSet("CONTEXTSELECTOR_CONTEXT_CHANGED") &&
                  $this->getVar("CONTEXTSELECTOR_CONTEXT_CHANGED") == 1)
            return;

        //also test to see if the template has changed
        if ($this->isVarSet("CONTEXTSELECTOR_TEMPLATE") &&
                  strcasecmp($this->getVar("CONTEXTSELECTOR_TEMPLATE"), $_SESSION["gszTemplate"]) != 0)
            return;

        if ($this->isVarSet("CONTEXTSELECTOR"))
        {
            $szLayersOn = $this->getVar("CONTEXTSELECTOR_LAYERS_ON");
            $aszLayersOn = explode("|", $szLayersOn);

            $oMap = $this->moMapObject->oMap;
            $nLayers = $oMap->numlayers;
            for ($i=0; $i<$nLayers; $i++)
            {
                $oLayer = $oMap->getLayer($i);

                // Only process WMS layers since some non-wms layers
                // shouldn't be turned off (for instance, Locate
                // widget use "temp_point" layer to manage points).
                if ($oLayer->connectiontype == MS_WMS)
                {
                    $szName = $oLayer->getMetadata("WMS_NAME");
                    if (in_array( $szName, $aszLayersOn ))
                    {
                        //echo "turning $szName on<BR>";
                        $oLayer->set("status", MS_ON);
                    }
                    else
                    {
                        //echo "turning $szName off<BR>";
                        $oLayer->set("status", MS_OFF);
                    }
                }
            }
        }

        // return success
        return true;
    }

    /**
     * CheckThemeOn
     *
     * Utility function to set on/off theme checkbox.
     */
    function CheckThemeOn($szThemeName)
    {
        $oMap = $this->moMapObject->oMap;
        $aszGroups = $this->moThemeParser->GetGroups($szThemeName);
        $szType = $this->moThemeParser->GetThemeAttribute( $szThemeName, "theme_type" );
        $bOn = ($szType == "checkbox");
        foreach( $aszGroups as $aszLayers )
        {
            foreach( $aszLayers as $szLayerName )
            {
                $oLayer = $this->GetLayerByWMSName($szLayerName);
                if ($oLayer->status == MS_OFF && $szType == "checkbox")
                {
                    return false;
                }
                else if ($oLayer->status == MS_ON && $szType == "radio")
                {
                    return true;
                }
           }
        }

        return $bOn;
    }

    /**
     * GetLayerByWMSName
     *
     * Return a layer if it's wms_name corresponds to the
     * szWMSName passed as argument
     */
    function GetLayerByWMSName( $szWMSName )
    {
        $poMap = $this->moMapObject->oMap;
        for ($i=0;$i<$poMap->numlayers;$i++)
        {
            $oLayer = $poMap->getLayer( $i );
            $szName = $oLayer->getmetadata( "WMS_NAME" );
            if (strcasecmp(trim($szName), $szWMSName) == 0)
            {
                return $oLayer;
            }
        }
        return false;
    }

    /**
     * return the status of a group of layers.  Assume that if any one
     * layer is 'on' then they are all on
     */
    function CheckGroupOn( $szThemeName, $szGroupName )
    {
        $aszLayers = $this->moThemeParser->maThemes[$szThemeName][$szGroupName];
        foreach( $aszLayers as $layer )
        {
            $oLayer = $this->GetLayerByWMSName($layer);
            if ($oLayer->status == MS_ON || $oLayer->status == MS_DEFAULT)
            {
                return true;
            }
        }
        return false;
    }

    /**
     * GetCurrentContext
     *
     * Get the current context used.
     */
    function GetCurrentContext()
    {
        if(isset($_SESSION["gszCurrentContext"]))
            $szContext= trim(basename($_SESSION["gszCurrentContext"]));
        else
            $szContext = "";

        return $szContext;
    }

    /**
     * DrawPublish
     *
     * Build layerconrol corresponding to the context and the theme
     * file associated.
     * The CWC tag looks like :
     * <cwc2 type="contextselector">
     *  <selection contextfile="path-to-context"
     *  themefile="path-to-theme" default="[true|false]"/>
     *  <selection .... />
     * </cwc>
     */
    function DrawPublish()
    {
        $this->moPopup->SetStyleResource();

        $oMap = $this->moMapObject->oMap;

        $szHTML="";

        $aVals = $this->moThemeParser->maVals;

        $aActiveLayers = array();

        //pre-process the layers in the map file and see if they are all supported
        for ($i=0; $i<$oMap->numlayers; $i++)
        {
            $oLayer = $oMap->GetLayer( $i );
            //only process WMS layers so temp annotation layers aren't affected
            if ($oLayer->connectiontype == MS_WMS)
            {
                $szLayer = $oLayer->getMetaData( "WMS_NAME" );
                if (array_key_exists( $szLayer, $this->moThemeParser->maLayers ) )
                {
                    $aActiveLayers[$szLayer] =
                            ($oLayer->status == MS_ON) ? " CHECKED" : "";
                }
            }
        }

        //need to update the inputs and urls for themes and groups now
        $i = 0; //track theme id
        $nLastThemeId = 0;
        $nLastGroupId = 0;

        foreach($this->moThemeParser->maThemes as $szThemeName => $aGroups)
        {
            $nThemeGroups = count($aGroups);

            $szAThemeGroups = "new Array(";
            $szThemeSep = "";
            $nThemeLayers = 0;

            //if there is a group in the theme
            if ($nThemeGroups > 0)
            {
                $theme_idx = $this->moThemeParser->GetThemeIndex( $szThemeName );
                $szThemeChecked = ($this->CheckThemeOn($szThemeName)) ? " CHECKED" : "";
                $szThemeAbstract = $this->moThemeParser->GetThemeAttribute( $szThemeName, "theme_abstract" );
                $szExtendThemeAbstract = $this->moThemeParser->GetThemeAttribute( $szThemeName, "theme_extendabstract" );
                $aVals["theme"][$theme_idx]["theme_input"] = "<input name=\"".$szThemeName.
                                     "\" type=\"checkbox\" value=\"".
                                     $szThemeName."\" onClick=\"".
                                     "ContextSelector_SetThemeStatus('".
                                     $i."', this.checked)\" ". $szThemeChecked.">";

                $j = 0; //track current group id

                foreach ($aGroups as $szGroupName => $aLayersInGroup)
                {
                    $szChecked = ($this->CheckGroupOn($szThemeName, $szGroupName)) ? " CHECKED" : "";
                    if ($nThemeGroups > 1)
                    {
                        $szOnClick = "onClick=\"ContextSelector_SetGroupStatus('$i', '$j', this.checked)\"";
                    }
                    else
                      $szOnClick ="onClick=\"ContextSelector_UpdateGroupsOn()\"";


                    $nGroupLayers = 0;
                    $szLayers = "";
                    $szSep = "";
                    foreach($aLayersInGroup as $szLayer)
                    {
                        if (array_key_exists( $szLayer, $aActiveLayers))
                        {
                            $szLayers .= $szSep."'".$szLayer."'";
                            $szSep = ",";
                            ++$nGroupLayers;
                        }
                    }

                    $szExtendGroupAbstract = $this->moThemeParser->GetGroupAttribute( $szThemeName, $szGroupName, "group_extendabstract" );
                    $szAGroupLayers = "new Array(";
                    if ($szExtendGroupAbstract == "true" && $nGroupLayers > 0)
                        $szAGroupLayers .= $szLayers;
                    $szAGroupLayers .= ")";

                    $szGroupAbstract = $this->moThemeParser->GetGroupAttribute( $szThemeName, $szGroupName, "group_abstract" );

                    $szGroupInfo = "'".$szGroupName."', '".$szGroupAbstract."', ".$szAGroupLayers;

                    $group_idx = $this->moThemeParser->GetGroupIndex( $szThemeName, $szGroupName );
                    $szInputType = $aVals["theme"][$theme_idx]["theme_type"];
                    $aVals["group"][$group_idx]["group_input"] = "<input name=\"".$szGroupName.
                          "\" type=\"".$szInputType."\" value=\"".$szGroupName."\" ".$szOnClick." ".$szChecked.">";
                    $aVals["group"][$group_idx]["group_url"] =
                              "javascript:ContextSelector_openGroupInfo(".$szGroupInfo.")";
                    $aVals["group"][$group_idx]["group_numlayers"] = "$nGroupLayers";

                    ++$j;
                    ++$nLastGroupId;

                    if ( $szExtendThemeAbstract == "true" )
                    {
                        $szAThemeGroups .= $szThemeSep."new Array(".$szGroupInfo.")";
                        $szThemeSep = ",";
                    }

                    $nThemeLayers += $nGroupLayers;
                }
            $szAThemeGroups .= ")";
            $aVals["theme"][$theme_idx]["theme_url"] =
                          "javascript:ContextSelector_openThemeInfo('".
                          $szThemeName."', '".$szThemeAbstract."', ".
                          $szAThemeGroups.")";
            $aVals["theme"][$theme_idx]["theme_numlayers"] = "$nThemeLayers";
            $aVals["theme"][$theme_idx]["theme_numgroups"] = "$nThemeGroups";
           }



            ++$i;
            ++$nLastThemeId;
       }

        $aVals["selection"] = $this->maSelections;

        $szHTML .= $this->moTemplateProcessor->ProcessTemplate( $this->mszRendererFile, $aVals );

        return $szHTML;
    }



}//end of class

?>

