<?php
/**
 * CompassPoint Widget class
 *
 * @project     CWC2
 * @revision    $Id: CompassPoint.widget.php,v 1.2 2004/04/24 21:58:04 pspencer Exp $
 * @purpose     CompassPoint Widget class
 * @author      DM Solutions Group (assefa@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
include_once(dirname(__FILE__)."/../NavTool.php");

define( "NORTHEAST", NORTH_EAST );
define( "NORTHWEST", NORTH_WEST );
define( "SOUTHEAST", SOUTH_EAST );
define( "SOUTHWEST", SOUTH_WEST );

/**
 * CompassPoint is an active pan arrow that can navigate the map
 * in one of eight directions by an optional factor.
 */
class CompassPoint extends NavTool
{
    var $mszImageName = "";
    var $mfPanPercent = 0.50;
    var $mszDirection = "";

    /**
     * constructor
     */
    function CompassPoint( )
    {
        // invoke constructor of parent
        parent::NavTool();

        // set the description for this widget
        $this->szWidgetDescription = <<<EOT
The CompassPoint widget is a clickable image that the user can click to pan
in a given direcion.
EOT;

        //CWCImage requires this attribute by default, this widget doesn't want it though.
        $this->maAttributes["IMAGE"] = new StringAttribute("IMAGE", false);
        $this->maAttributes["DIRECTION"] = new StringAttribute( "DIRECTION", true,
            array( NORTHEAST, NORTH, NORTHWEST, WEST, SOUTHWEST, SOUTH, SOUTHEAST, EAST ) );
        $this->maAttributes["PANPERCENT"] = new IntegerAttribute( "PANPERCENT", false, 0, 100 );
    }

    /**
     * initialize default values
     */
    function InitDefaults()
    {
        parent::InitDefaults();

        if (isset($this->maParams["PANPERCENT"]))
            $this->mfPanPercent = floatval($this->maParams["PANPERCENT"])/100;
        if ( $this->mfPanPercent < 0.0 )
            $this->mfPanPercent = 0.5;
        if ( $this->mfPanPercent > 1.0 )
            $this->mfPanPercent = 1.0;

        if (isset($this->maParams["DIRECTION"]))
            $this->mszDirection = $this->maParams["DIRECTION"];

        $this->SetNavCommand("COMPASS_POINT_".$this->mszDirection);

        if (isset($this->maParams["IMAGE"]))
        {
            $this->mszImageName = $this->maParams["IMAGE"];
        }
        $this->mbSubmitOnClick = 1;
    }

    /**
     * look through the URL parameters for something that indicates a
     * pan is requested and perform it if necessary
     */
    function  ParseURL()
    {
        parent::ParseURL();

        $szCmd = "";
        if ($this->isVarSet("NAV_CMD"))
            $szCmd = $this->getVar("NAV_CMD");

        if (substr($szCmd, 0, 13) == "COMPASS_POINT")
        {
            $szDirection = strtoupper(substr( $szCmd, 14 ));

            if (strcasecmp($this->mszDirection, $szDirection) == 0)
            {
                eval("\$this->moMapNavigator->pan( $szDirection, \$this->mfPanPercent );");
            }
        }

        return true;
    }

    /**
     * publish this widget
     * @return string the html code representing this widget
     */
    function DrawPublish()
    {
        if (strlen($this->mszDirection) == 0)
            return "<!-- MISSING DIRECTION IN COMPASSPOINT WIDGET -->";

        if ($this->mbVisible == false)
            return "<!-- CompassPoint $this->mszDirection is hidden -->";

        return parent::DrawPublish();
    }
}
?>
