<?php
/**
 * This function takes a array return by xml_parse_into_struct
 * and parse it to build a PHP object containing all info of
 * current document.
 *
 * XML document is returned as an PHP object that can be
 * accessed this way:
 *
 * Sample XML document:
 * <Employees version="1.0">
 *   <Employee Id="1">
 *     <Name>John</Name>
 *     <Salary Type="Annualy">20K</Salary>
 *   </Employee>
 *   <Employee Id="2">
 *     <Name>Ren</Name>
 *     <Salary Type="Weekly">2K</Salary>
 *   </Employee>
 * </MyRoot>
 *
 * Sample PHP code:
 * $MyDoc = xml_ge_children(parse_into_struct(...));
 * if $MyDoc->Employees->attributes['version'] >= "1.0")
 * {
 *   foreach($MyDoc->Employees->value->Employee as $oEmployee)
 *   {
 *     echo $oEmployee->attributes['Id']." ";
 *     echo "Name: ".$oEmployee->value->Name->value;
 *     echo "Paid: ".$oEmployee->value->Salary->value."(";
 *     echo $oEmployee->value->Salary->attributes['Type'].")";
 *   }
 * }
 * else
 *   echo "Wrong document version";
 *
 *
 * PS: This code was not tested.
 */
function xml_get_children(&$vals) 
{
    $children = new Foo();
    
    $j = count($vals);

    while ($GLOBALS['i']++ < $j) 
    {
        $k = $GLOBALS['i'];

        // if current record is a closing tag
        if (isset($vals[$k]['type']) && $vals[$k]['type'] == "close")
            return $children;

        // Check if there's already a tage with that name
        // If so and it is not an array, set it as an array
        if (@isset($children->$vals[$k]['tag']) && 
            !is_array($children->$vals[$k]['tag']))
        {
            $oTmp = $children->$vals[$k]['tag'];
            $children->$vals[$k]['tag'] = array($oTmp);
        }
        if (isset($vals[$k]))
        {
            switch ($vals[$k]['type']) 
            {
                // If current record is a complete tag or cdata
                case 'cdata':
                case 'complete':
                    // if current record is an array
                    if (@is_array($children->$vals[$k]['tag']))
                    {
                        // Set attributes property
                        $o->attributes = (isset($vals[$k]['attributes']) ? 
                                         $vals[$k]['attributes'] : array());
    
                        // Set value property
                        $o->value = (isset($vals[$k]['value']) ? 
                                    $vals[$k]['value'] : "");
    
                        // Add it to current record (to an array)
                        array_push($children->$vals[$k]['tag'], $o);
                    }
                    else // It is not an array, so add it as a simple attribute
                    {
                        $children->$vals[$k]['tag']->attributes = 
                                        (isset($vals[$k]['attributes']) ? 
                                         $vals[$k]['attributes'] : array());
                        $children->$vals[$k]['tag']->value = 
                                        (isset($vals[$k]['value']) ? 
                                        $vals[$k]['value'] : "");
                    }
                break;
    
                // If current record is an open tag
                case 'open':
                    if (@is_array($children->$vals[$k]['tag']))
                    {
                        $o->attributes = (isset($vals[$k]['attributes']) ? 
                                          $vals[$k]['attributes'] : array());
    
                        // Call function recursivly
                        $o->value = xml_get_children($vals);
    
                        array_push($children->$vals[$k]['tag'], $o);
                    }
                    else
                    {
                        $children->$vals[$k]['tag']->attributes = 
                                        @(isset($vals[$k]['attributes']) ? 
                                         $vals[$k]['attributes'] : array());
    
                        // Call function recursivly
                        $children->$vals[$k]['tag']->value = xml_get_children($vals);
                    }
                break;
            }
        }
    }

    // Return last created object
    return $children;
}

class Foo
{
}

$GLOBALS['i']=-1;
?>