<?php
/**
 * utilities file
 * 
 * @project     PHP Wrapper Class
 * @revision    $Id: utilities.php,v 1.2 2002/02/28 04:46:35 bronsema Exp $
 * @purpose     This file contains various generic php utilties.
 * @author      William A. Bronsema, C.E.T. (bronsema@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2001, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: utilities.php,v $
 * Revision 1.2  2002/02/28 04:46:35  bronsema
 * no message
 *
 * Revision 1.1  2002/02/28 00:57:41  bronsema
 * Under Construction
 *
 *****************************************************************************/

/**
 * This function loads the specified module if necessary.
 *
 * @param szModuleType string - The type of module to load (i.e. "MapScript")
 *
 * @param szModuleName string - The name of the module to load 
 *                              (i.e. "php_mapscript_35.dll")
 */
function load_module($szModuleType,$szModuleName)
{
    // check if the module is loaded
    if (!extension_loaded($szModuleType)) dl($szModuleName);

// end function
}

/**
 * returns a default value when supplied value is invalid for either a string
 * or numeric value
 *
 * @param Value mixed the value to check
 *
 * @param Default mixed the value to return if default is necessary
 *
 * @param szType string the type of the value to check
 *
 * the value type can be any of the following:
 *
 *              "s" or "S" for string
 *              "n" or "N" for numeric
 *
 * an error message will be issued if the type is indeterminate
 *
 * @return mixed either the default value or the value itself
 */
function default_value($Value, $Default, $szType)
{
    // process for the correct type
    switch (strtoupper($szType))
    {
        // type is string
        case "S":

            // check for empty
            if ($Value == "")
            {
                // empty so default
                return $Default;
            }
            else
            {
                // not empty so return value
                return $Value;
            }

        // type is numeric
        case "N":

            // check for numeric
            if (is_numeric($Value))
            {
                // is numeric so return value
                return $Value;
            }
            else
            {
                // not numeric so default
                return $Default;
            }

        // invalid type
        default:

            // trigger error
            trigger_error("Invalid type supplied to default_value() function.");

    // end switch
    }

// end function
}

/**
 * reads the given textfile to an array
 *
 * @param szfilename string the textfile to read
 *
 * @return array or false if unsuccessful
 */
function ReadStringList($szfilename)
{
    // define array variable
    $list = array();

    // attempt to open the file
    if (!($fp = fopen($szfilename, "r")))
    {
        // error occurred
        //trigger_error("ReadStringList(): Could not open $szfilename");

        // return failure
        return FALSE;
    }

    // file is open so parse each entry
    while($fp && !feof($fp))
    {
        // get next line
        $line = fgets($fp, 4096);

        // trim() strips off whitespaces and \r and \n
        $line = trim($line);
        if (strlen($line) > 0)
            array_push($list, $line);
    }

    // close the file
    fclose($fp);

    // return the array
    return $list;
}

/**
 * write the given array to the specified textfile
 *
 * @param szfilename string the textfile to write to
 *
 * @param aszlist array the array write
 *
 * @return boolean to indicate success
 */
function WriteStringList($szfilename, $aszlist)
{
    // open the file
    if (!($fp = fopen($szfilename, "w")))
    {
        // open failed so give error
        //trigger_error("WriteStringList(): Could not open $szfilename");

        // return failure
        return FALSE;
    }

    // loop through the array an dwrite to file
    foreach ($aszlist as $line)
    {
        // write entry to file
        fputs($fp, $line."\n");
    }

    // close the file
    fclose($fp);

    // return success
    return TRUE;
}


?>
