<?
/**
 * DirectorySessionHandler Module
 *
 * @project     PHP Utils classes
 * @revision    $Id:
 * @purpose     this file contains classe session management in sub-directory
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log:
 *
 */
/**
 * Global variable needed by functions handler
 */

$bDebug = false;
$szDebugDir = "/tmp/";

/**
 * _open Called by PHP session manager when a session is opened.
 * We just set the save path and session name into global variable.
 *
 * @param szSavePath String containing the absolute path where to
 *        save session info.
 * @param szSessionName String contqaining the session name.
 */
function _open($szSavePath, $szSessionName)
{
    printDebug("Opened() ".$GLOBALS['gszSessDatabase'].", ".
               $GLOBALS['gszSessTable'].", ".$GLOBALS['gszSessHost'].", ".
               $GLOBALS['gszSessUser'].", "."pass"."\n");
    printDebug("session_id() says ".session_id()."\n");

    $GLOBALS['gszSessName'] = $szSessionName;
    $GLOBALS['gszSessId'] = session_id();

    // Insert the initial record in the database if does not already exist
    
    $szQuery = "SELECT HIGH_PRIORITY sid FROM ".$GLOBALS['gszSessTable'].
        " WHERE sid='".$GLOBALS['gszSessId']."'";
    printDebug("Query: $szQuery\n");

    if( ! ($hRes = mysql_query($szQuery, $GLOBALS['session_link'])))
    {
        printDebug("Query ERROR: ".mysql_error()."\n");
        return("");
    }

    if ( mysql_num_rows($hRes) == 0)
    {
        $szQuery = "INSERT INTO ".$GLOBALS['gszSessTable']." (sid,accesstime)".
            " VALUES (\"".$GLOBALS['gszSessId']."\", UNIX_TIMESTAMP())";

        printDebug("Query: $szQuery\n");

        if( ! ($hRes = mysql_query($szQuery)))
        {
            printDebug("Query ERROR: ".mysql_error()."\n");
            return(false);
        }
    }

    return(true);
}

/**
 * _close Called by PHP session manager when a session is closed,
 * not destroyed. In this case we do nothing.
 */
function _close()
{
    printDebug("Close session\n");

    return(true);
}

/**
 * _read Called by PHP session manager when the session file
 * is read. In this case we just return the file content of
 * session_file file.
 */
function _read($szId)
{

    $GLOBALS["gszSessId"] = $szId;

    printDebug("Read() $szId\n");

    // Get the session record content
    $szQuery = "SELECT HIGH_PRIORITY content FROM ".$GLOBALS['gszSessTable'].
        " WHERE sid='$szId'";
    printDebug("Query: $szQuery\n");

    if( ! ($hRes = mysql_query($szQuery, $GLOBALS['session_link'])))
    {
        printDebug("Query ERROR: ".mysql_error()."\n");
        return("");
    }

    if (($aszSessionData = mysql_fetch_row($hRes)) != "")
    {
        return(stripslashes($aszSessionData[0]));
    }
    else
    {
        return(""); // Must return "" here.
    }
}

/**
 * _write Called by PHP session manager when session should be
 * saved.
 *
 * @param szId String containing the unique identifier of current
 *             session.
 * @param szSessionData String containig the session file content
 *                      to be saved.
 */
function _write($szId, $szSessionData)
{
    $result = false;
    printDebug("Write() $szId $szSessionData\n");

    $szSessionData = addslashes($szSessionData);

    // Get the session record content
    $szQuery = "UPDATE ".$GLOBALS['gszSessTable'].
        " SET content=\"$szSessionData\", accesstime=UNIX_TIMESTAMP() WHERE sid='$szId'";
    printDebug("Query: $szQuery\n");

    $hRes = mysql_query($szQuery, $GLOBALS['session_link']);
    if($hRes == false)
    {
        printDebug("Query ERROR: ".mysql_error()."\n");
        return($result);
    }
    else
        $result = true;

    return($result);
}

/**
 * _destroy Called by PHP session manager when it should be explicitly
 * destroyed now.
 */
function _destroy($szId)
{
    printDebug("Destroy $szId\n");

    return true;
}

/**
 * _gc Called by PHP session manager when a session is started or
 * register (not all the time) depending og session.gc_probability
 */
function _gc($nMaxLifeTime)
{
    if ($GLOBALS['gszGarbageColectionCallBackFunction'] != "")
    {
        if (function_exists($GLOBALS['gszGarbageColectionCallBackFunction']))
            eval($GLOBALS['gszGarbageColectionCallBackFunction']);
    }

    // Get the session record content
    $szQuery = "DELETE LOW_PRIORITY QUICK FROM ".$GLOBALS['gszSessTable'].
      " WHERE accesstime<(UNIX_TIMESTAMP()-$nMaxLifeTime)";
    printDebug("Query: $szQuery\n");

    if(mysql_query($szQuery, $GLOBALS['session_link']) === false)
    {
        printDebug("Query ERROR: ".mysql_error()."\n");
        return(false);
    }

    return true;
}

////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////


function installSessionDirectoryHandler($szGCCallBack="")
{
    $GLOBALS['gszGarbageColectionCallBackFunction'] = $szGCCallBack;

    // Set handler functions
    session_set_save_handler("_open",
                             "_close",
                             "_read",
                             "_write",
                             "_destroy",
                             "_gc");
}

function initializeSession( $szSessName="sid", $szSessSavePath="",
                            $szSessionID="" )
{
    if ($szSessName == "")
    {
        echo "<FONT color=#FF0000>FATAL ERROR: Sessionname not specified</FONT>";
        exit;
    }
    else
        ini_set("session.name", $szSessName);

    if ($szSessSavePath != "")
    {
        ini_set("session.save_path", $szSessSavePath);
    }
    readMySQLSavePath();

    //turn off cookies for propagating session ids
    ini_set( "session.use_cookies", "0" );

    // turn off tranparent SID (becuase of buffer problem)
    ini_set( "session.use_trans_sid", "0" );

    // intialize tmp id
    $szTmpID = "";

    // check both get and post variables
    if ( isset($GLOBALS['_GET'][ini_get('session.name')]) )
        $szTmpID = $GLOBALS['_GET'][ini_get('session.name')];
    elseif (isset($GLOBALS['_POST'][ini_get('session.name')]))
        $szTmpID = $GLOBALS['_POST'][ini_get('session.name')];

    // create new if necessary
    if ( strlen( $szTmpID ) <= 0 )
    {
        // create new and set IP flag
        if ( strlen( $szSessionID ) > 0 )
            $szTmpID = $szSessionID;
	else        	
            $szTmpID = uniqid("");
        $bNewSession = true;
    }
    else
        $bNewSession = false;

    // initialize flag variable
    $bSessionOK = true;

    // set the session ID
    session_id( $szTmpID );

    // Check if session is expired
    if (!$bNewSession)
    {
        // Get the session record content
        $szQuery = "SELECT HIGH_PRIORITY content FROM ".$GLOBALS['gszSessTable'].
            " WHERE sid='$szTmpID' AND ".
            "accesstime>=(UNIX_TIMESTAMP()-".ini_get("session.gc_maxlifetime").")";
        printDebug("Query: $szQuery\n");

        if( ! ($hRes = mysql_query($szQuery, $GLOBALS['session_link'])))
        {
            printDebug("Query ERROR: ".mysql_error()."\n");
            return("");
        }

        if (mysql_num_rows($hRes) <= 0)
        {
            $szTmpID = uniqid("");

            // reset the session ID
            session_id( $szTmpID );

            $bNewSession = true;
            $bSessionOK = false;
        }
    }

    //start the session
    session_start();
    register_shutdown_function( "session_write_close" );

    // set IP if a new session
    if ( $bNewSession ) $_SESSION["gszRemoteAdd"] = $_SERVER["REMOTE_ADDR"];

/* ============================================================================
 * Check IP to see if it is the same
 * ========================================================================= */

    if (!isset($_SESSION["gbIgnoreIPChange"]) || 
        $_SESSION["gbIgnoreIPChange"] == false)
    {
        // check if the IP has been set and validate
        if ( isset( $_SESSION["gszRemoteAdd"] ) &&
             strlen(trim($_SESSION["gszRemoteAdd"])) > 0 )
        {
            // check if IP matches current client
            if ( trim( $_SESSION["gszRemoteAdd"] ) !=
                 trim( $_SERVER["REMOTE_ADDR"] ) )
            {
                // possible security breach void session
                $bSessionOK = false;
            }
        }
        else
        {
            // possible security breach void session
            $bSessionOK = false;
        }
    }

    // return success or failure
    return $bSessionOK;

// end intializeSession() function
}

function &getMySQLConnection()
{
    // Connect to the MySQL database
    $link = mysql_pconnect($GLOBALS['gszSessHost'], $GLOBALS['gszSessUser'], 
                          $GLOBALS['gszSessPassword']);

    $GLOBALS['session_link'] = $link;

    if($link === false)
    {
        printDebug("MySQL connection error: ".mysql_error()."\n");
        return(false);
    }

    if( !mysql_select_db($GLOBALS['gszSessDatabase']) )
    {
        return(false);
    }

//    return $link;
    return true;
}

function printDebug($szDebugInfo)
{
    if ($GLOBALS["bDebug"])
    {
      $fh = fopen($GLOBALS['szDebugDir']."session.log", "a+");
      fwrite($fh, $szDebugInfo);
      fclose($fh);
    }

    return;
}

function getSessionSavePath()
{
    return "/tmp/";
}

/**
 * Read the session.save_path and set global variable with it.
 */
function readMySQLSavePath()
{
    $szSessionSavePath = ini_get("session.save_path");
    $szSessionSavePath = preg_replace("/__tttexcl__/", "!",$szSessionSavePath);
    // Check if save path is mysql
    if (strtoupper(substr($szSessionSavePath, 0, 8)) != "MYSQL://")
    {
        echo "<FONT COLOR=#DD0000>FATAL ERROR: Session save path (".ini_get("session.save_path").") doesn't exist or is not writable</FONT>";
        exit;
    }
    printDebug($szSessionSavePath);
    if(preg_match("/MYSQL:\\/\\/[^@]*/i",$szSessionSavePath, $aszMatches))
        $szUser = substr(trim($aszMatches[0]), 8);;
    if(preg_match("/@[^:]*/i", $szSessionSavePath, $aszMatches))
        $szPass = substr(trim($aszMatches[0]), 1);
    if(preg_match("/[^MYSQL:\\/\\/]:[^\\/]*/i",$szSessionSavePath,$aszMatches))
        $szHost = substr(trim($aszMatches[0]), 2);
    if(preg_match("/\w\\/[^\\.]*/i", $szSessionSavePath, $aszMatches))
        $szDatabase = substr(trim($aszMatches[0]), 2);
    if(preg_match("/\\..*/i", $szSessionSavePath, $aszMatches))
        $szTable = substr(trim($aszMatches[0]), 1);
    else
        $szTable = "session";

    $GLOBALS['gszSessDatabase'] = $szDatabase;
    $GLOBALS['gszSessTable'] = $szTable;
    $GLOBALS['gszSessHost'] = $szHost;
    $GLOBALS['gszSessUser'] = $szUser;
    $GLOBALS['gszSessPassword'] = $szPass;
    getMySQLConnection();

    printDebug("readMySQLSavePath(): D=$szDatabase T=$szTable H=$szHost U=$szUser P=$szPass \n");
}
?>
