<?php
/**
 * LayerPicker is a WEB interface that let the user choose a layer
 * from a map file.
 *
 * Package(s) used: TreeMenu
 *
 * @author Sacha Fournier (sfournier@dmsolutions.ca)
 * @project PhpUtil
 * @revision $Id
 * @purpose Simple graphic interface that display all layers from
 *          a map file and let user choose one. A variable that
 *          contain the map file name (szImportableMapFiles) must
 *          be set in session. It can contain more than one map file.
 *          Each Map file name must be seperated by "|".
 *
 *          The function return the layer index that the user choosed
 *          with the map file name.
 *
 *          The PHP mapscript module name can be specified by the
 *          $_SESSION["gszPHPMapScriptModName"] variable. If not specified, default
 *          name is used.
 *
 * @copyright Copyright DM Solutions Group Inc 2002 All Rights Reserved
 *
 */

include_once("../session/session.php");
installSessionDirectoryHandler();
initializeSession();

// convert the global session reference if necessary
if ( PHP_OS == "WINNT" || PHP_OS == "WIN32" )
{
    if ( version_compare( phpversion(), "4.2.1" ) < 0 )
        $_SESSION = &$HTTP_SESSION_VARS;
}

include_once("../logger/logger.php");
include_once("../treemenu/treemenu.php");

class LayerPicker extends Logger
{
    var $m_oTreeMenu;
    /**
     * LayerPicker( )
     *
     *
     * @return (NONE)
     **/
    function LayerPicker ()
    {
        $this->Logger("Layer picker");
        /**
         * Create TreeMenu
         */
        $this->m_oTreeMenu = new TreeMenu();

        $this->m_oTreeMenu->m_oTreeMenuImages->set(img_error, "../treemenu/images/error.gif");
        $this->m_oTreeMenu->m_oTreeMenuImages->set(img_expand_split, "../treemenu/images/tree_plus_split.gif");
        $this->m_oTreeMenu->m_oTreeMenuImages->set(img_collapse_split, "../treemenu/images/tree_minus_split.gif");
        $this->m_oTreeMenu->m_oTreeMenuImages->set(img_expand_end, "../treemenu/images/tree_plus_end.gif");
        $this->m_oTreeMenu->m_oTreeMenuImages->set(img_collapse_end, "../treemenu/images/tree_minus_end.gif");
        $this->m_oTreeMenu->m_oTreeMenuImages->set(img_line, "../treemenu/images/tree_line.gif");
        $this->m_oTreeMenu->m_oTreeMenuImages->set(img_split, "../treemenu/images/tree_split.gif");
        $this->m_oTreeMenu->m_oTreeMenuImages->set(img_end, "../treemenu/images/tree_end.gif");
        $this->m_oTreeMenu->m_oTreeMenuImages->set(img_spc, "../treemenu/images/tree_space.gif");

        $this->m_oTreeMenu->setParams("szTemplatePart=PICKER");
        $this->m_oTreeMenu->setScript("nodeClicked");
    }

    function parseMapFiles($szWarehouseMapFiles, $szStates)
    {
        $aszWarehouseMapFile = explode("|", $szWarehouseMapFiles);

        $szCurDir = getcwd();

        /* -------------------------------------------------------------------- */
        /*      Load required modules                                           */
        /* -------------------------------------------------------------------- */
        if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
        {
            if (!extension_loaded("MapScript"))
            {
                /**
                 * Check if a module name is specified.
                 * If so, use it. If not takes the default
                 * one.
                 */
                if (!isset($_SESSION["gszPHPMapScriptModName"]))
                    $_SESSION["gszPHPMapScriptModName"] = "php_mapscript.dll";

                dl($_SESSION["gszPHPMapScriptModName"]);
            }
        }
        else
        {
            if (!extension_loaded("MapScript"))
            {
                /**
                 * Check if a module name is specified.
                 * If so, use it. If not takes the default
                 * one.
                 */
                if (!isset($_SESSION["gszPHPMapScriptModName"]))
                    $_SESSION["gszPHPMapScriptModName"] = "php_mapscript.so";

                dl($_SESSION["gszPHPMapScriptModName"]);
            }
        }

        $aszLayerList = array();
        $j=0;

        foreach($aszWarehouseMapFile as $szMapFile)
        {
            /**
             * Check if map file exist
             */
            if (file_exists($szMapFile) && (substr($szMapFile, -3)=="map"))
            {
                /**
                 * Open map file
                 */
                $oMapObj = ms_newMapObj($szMapFile);

                /**
                 * Build array of TreeMenu nodes
                 */
                array_push($aszLayerList, ".|../treemenu/images/tree_server.gif|$oMapObj->name");

                for ($i=0; $i<$oMapObj->numlayers; $i++)
                {
                    $oLayer = $oMapObj->getLayer($i);
                    array_push($aszLayerList, "..|../treemenu/images/tree_layer.gif|$oLayer->name|javascript:SelectLayer($i, $j, '".$oLayer->name."', '".$oMapObj->name."')");
                }
            }
            $j++;
        }

        $this->m_oTreeMenu->m_aszTreeStructure = $aszLayerList;

        $this->m_oTreeMenu->loadTreeStructure();

        $this->m_oTreeMenu->restoreStates($szStates);

        $this->m_oTreeMenu->setTitle("<FONT FACE=\"Arial\" SIZE=\"2\"><B>Warehouse Layers:</B></FONT>");
        $this->m_oTreeMenu->setFont("<FONT FACE=\"Arial\" SIZE=\"2\">");

        chdir($szCurDir);
    }
}

$oPicker = new LayerPicker();
$oPicker->parseMapFiles($_SESSION["gszWarehouseMapFiles"], $_GET["p"]);
?>
