<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" indent="yes"/>

<xsl:template match="root">
<HTML>
<HEAD>
      <TITLE><xsl:value-of select="MainTitle"/></TITLE>
</HEAD>

<SCRIPT>
select_on = new Image;
select_on.src = "../images/bar.gif";
select_off = new Image;
select_off.src = "../images/a_pixel.gif";

var szSelected = 0;

function selectIt( nIndex )
{
    document.images["bar"+szSelected].src = "../images/a_pixel.gif";
    document.images["bar"+nIndex].src = "../images/bar.gif";

    szSelected = nIndex;
}
</SCRIPT>

<BODY bgcolor="#FFFFFF">
<xsl:attribute name="onload">selectIt('<xsl:value-of select="SelectedSymbol"/>')</xsl:attribute>
   <FONT FACE="Arial,Helvetica,sans-serif" size="2"><B>Click a symbol to select it</B></FONT><BR/>
    <FORM name="myForm">
    <CENTER>
    <TABLE BORDER="0" CELLSPACING="0" CELLPADDING="2">
    <TR>
      <TD></TD>
      <TD>
      <IMG BORDER="0" WIDTH="2" HEIGHT="20">
       <xsl:attribute name="src">../images/a_pixel.gif</xsl:attribute>
      <xsl:attribute name="name">bar0</xsl:attribute>
      </IMG>
      </TD>
      <TD COLSPAN="10">
      <a href="">
        <xsl:attribute name="href">javascript:selectIt('0')</xsl:attribute>
        <FONT FACE="Arial,Helvetica,sans-serif" size="2">No symbol</FONT>
      </a>
      </TD>
    </TR>
    <xsl:apply-templates select="Symbols"/>
            </TABLE>
       </CENTER>
      </FORM>
</BODY>
</HTML>
</xsl:template>

<xsl:template match="Symbol">
    <TD><FONT FACE="Arial,Helvetica,sans-serif" size="2"><xsl:value-of select="SymbolId"/>:</FONT></TD>
    <TD>
       <IMG BORDER="0" WIDTH="2" HEIGHT="20">
       <xsl:attribute name="src">../images/a_pixel.gif</xsl:attribute>
       <xsl:attribute name="name">bar<xsl:value-of select="SymbolId"/></xsl:attribute>
       </IMG>
    </TD>
    <TD>
       <A>
            <xsl:attribute name="onClick">selectIt(<xsl:value-of select="SymbolId"/>)</xsl:attribute>
            <IMG border="0">
                <xsl:attribute name="src"><xsl:value-of select="SymbolUrl"/></xsl:attribute>
            </IMG>
        </A>
    </TD>
</xsl:template>

<xsl:template match="Symbols">
    <xsl:for-each select="Symbol[position() mod 4 = 1]">
        <tr>
            <xsl:apply-templates select=". | following-sibling::Symbol[position() &lt; 4]"/>
        </tr>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
