<?
/* ============================================================================
 * HTTP_FORM_VARS array contains the HTTP GET or POST parameters
 * ========================================================================= */
$szURL             = (isset($http_form_vars['szURL'])) ? $http_form_vars['szURL'] : "";
$szName            = (isset($http_form_vars['szName'])) ? $http_form_vars['szName'] : "";
$nMaxId            = (isset($http_form_vars['nMaxId'])) ? $http_form_vars['nMaxId'] : "";
$szComment         = (isset($http_form_vars['szComment'])) ? $http_form_vars['szComment'] : "";
$szServerId        = (isset($http_form_vars['szServerId'])) ? $http_form_vars['szServerId'] : "";
$szSelectedServers = (isset($http_form_vars['szSelectedServers'])) ? $http_form_vars['szSelectedServers'] : "";

$szCommand         = (isset($http_form_vars['szCommand'])) ? $http_form_vars['szCommand'] : "";

$szWMSParseFile    = ((isset($_SESSION["gszWMSParseFile"])) ? $_SESSION["gszWMSParseFile"] :
                           (( PHP_OS == "WINNT" || PHP_OS == "WIN32" ) ? "../wmsparse/win32/wmsparse.exe" :
                                                                        "../wmsparse/wmsparse"));

$oServerManager = new ServerManager($_SESSION["gszServerDataPath"], $szWMSParseFile);

/* ============================================================================
 * Process a add request.
 * ========================================================================= */
if ( $szCommand == "ADD" )
{
    $oServerManager->add($szURL, $szName, $nMaxId, $szComment);
}

/* ============================================================================
 * Process a update request.
 * ========================================================================= */
if ( $szCommand == "UPDATE" )
{
    $oServerManager->update($szName, $szURL, $szServerId, $szComment);
}

/* ============================================================================
 * Process a connect request.
 * ========================================================================= */
if ( $szCommand == "CONNECT" )
{
    $oServerManager->connect($szSelectedServers, $http_form_vars);
}

/* ============================================================================
 * Process a disconnect request.
 * ========================================================================= */
if ( $szCommand == "DISCONNECT" )
{
    $oServerManager->disconnect($szSelectedServers, $http_form_vars);
}

/* ============================================================================
 * Process a remove request.
 * ========================================================================= */
if ( $szCommand == "REMOVE" )
{
    $oServerManager->remove($szSelectedServers, $http_form_vars);
}

/* ============================================================================
 * Process a refresh request.
 * ========================================================================= */
if ( $szCommand == "REFRESH" )
{
    $oServerManager->refresh($szSelectedServers, $http_form_vars);
}

/* ============================================================================
 * Process a test request.
 * ========================================================================= */
if ( $szCommand == "TEST" )
{
    $oServerManager->test($szSelectedServers, $http_form_vars);
}

/* ============================================================================
 * Build the treemenu file
 * ========================================================================= */
if ( isset($http_form_vars["bNotFirstLoad"]) && $http_form_vars["bNotFirstLoad"] == 1 )
{
    $oServerManager->m_szStatus .= "Building treemenu file....";
    if ( !$oServerManager->m_oServerDataManager->createTreemenu( $_SESSION["gszServerDataPath"]."server.treemenu", $oServerManager ) )
        $oServerManager->m_szStatus .= "Failed\n";
    else
        $oServerManager->m_szStatus .= "OK\n";
}
else
    $http_form_vars["bNotFirstLoad"] = 0;

/* ============================================================================
 * Open the servers database and process the contents into the list box array
 * ========================================================================= */
$oServerManager->m_szStatus .= "Building server list....";
$aszServer = $oServerManager->m_oServerDataManager->buildServersList( $_SESSION["gszServerDataPath"]);
$oServerManager->m_szStatus .= "OK\n";

/* ============================================================================
 * Check for errors
 * ========================================================================= */
if ( $oServerManager->oErrorManager->nErrorCount > 0 )
{
    // list errors
    $oServerManager->m_szStatus .= "The following errors occurred:\n";
    for ( $i=0; $i<$oServerManager->oErrorManager->nErrorCount; $i++ )
    {
        $oTmpError = $oServerManager->oErrorManager->getError($i);
        $oServerManager->m_szStatus .= strval($i+1).") ".$oTmpError->szMessage."\n";
    }

    // flag errors
    $oServerManager->m_bStatus = false;
}

/* ============================================================================
 * Give exit info
 * ========================================================================= */
if ( count( $aszServer ) < 1 )
    $oServerManager->m_szStatus .= "No servers in the list.\n";

$oServerManager->m_szStatus .= "\n*** Execution complete ";

if (!$oServerManager->m_bStatus)
    $oServerManager->m_szStatus .= "- Errors Occurred ";

$oServerManager->m_szStatus .= "***\n";
?>
