<?php
/**
 * MapBrowser application
 *
 * @project     MapLab
 * @revision    $Id: manage_servers.php,v 1.12 2003/05/28 19:42:44 sacha Exp $
 * @purpose     This server management supporting php code.
 * @author      William A. Bronsema, C.E.T. (bronsema@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: manage_servers.php,v $
 * Revision 1.12  2003/05/28 19:42:44  sacha
 * removed useless code
 *
 * Revision 1.11  2002/11/19 19:20:24  sacha
 * Fixed some session bugs
 *
 * Revision 1.10  2002/11/19 13:48:21  sacha
 * seperate manage server interface into part.
 *
 * Revision 1.9  2002/10/25 15:30:10  sacha
 * added functionality to layer browser.
 *
 * Revision 1.8  2002/09/05 15:37:55  bronsema
 * added check for dbase module
 *
 * Revision 1.7  2002/07/07 17:49:23  pspencer
 * fixed 'update server' to check url and refresh automatically
 *
 * Revision 1.6  2002/07/02 20:00:38  pspencer
 * more updates for include handling
 *
 * Revision 1.4  2002/06/30 20:58:39  pspencer
 * added support for sessions by url and register_globals=off
 *
 * Revision 1.2  2002/06/17 18:15:12  sacha
 * moved php wms dialogs and component to php_utils.
 *
 * Revision 1.1  2002/06/14 14:32:32  sacha
 * *** empty log message ***
 *
 * Revision 1.8  2002/06/13 16:54:04  bronsema
 * Made the error manager local not global
 *
 * Revision 1.7  2002/06/13 14:10:27  sacha
 * Change copywrite
 *
 * Revision 1.6  2002/05/29 15:30:57  pspencer
 * fixed references to global log file and error manager
 *
 * Revision 1.4  2002/05/28 20:33:01  pspencer
 * updated to handle errors in process better
 *
 * Revision 1.2  2002/05/28 14:27:33  pspencer
 * refresh servers on add
 *
 * Revision 1.1  2002/05/16 16:52:27  bronsema
 * Initial addition
 *
 *****************************************************************************/
// ensure that the dbase module is loaded
if (PHP_OS == "WINNT" || PHP_OS == "WIN32")
{
    if (!extension_loaded("dbase")) dl("php_dbase.dll");
}

if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON ) - 1, 1 ) == "/" )
    {
        include_once( COMMON."logger/logger.php");
        include_once( COMMON."logger/error_manager.php");
        include_once( COMMON."phpwms/xpath.class.php");
        include_once( COMMON."phpwms/server_data_manager.php");
        include_once( COMMON."phpwms/dbf.php");
    }
    else
    {
        include_once( COMMON."/logger/logger.php");
        include_once( COMMON."/logger/error_manager.php");
        include_once( COMMON."/phpwms/xpath.class.php");
        include_once( COMMON."/phpwms/server_data_manager.php");
        include_once( COMMON."/phpwms/dbf.php");
    }
}
elseif (file_exists("../logger/logger.php"))
{
    include_once("../logger/logger.php");
    include_once("../logger/error_manager.php");
    include_once("../phpwms/xpath.class.php");
    include_once("../phpwms/server_data_manager.php");
    include_once("../phpwms/dbf.php");
}
else
{
    include_once("./logger/logger.php");
    include_once("./logger/error_manager.php");
    include_once("./phpwms/xpath.class.php");
    include_once("./phpwms/server_data_manager.php");
    include_once("./phpwms/dbf.php");
}


class ServerManager extends Logger
{
    var $m_szStatus;
    var $m_bStatus;

    var $m_oServerDataManager;

    var $m_szWMSParseFile;
    var $m_szServerDataPath;

    function ServerManager($szServerDataPath, $szWMSParseFile="")
    {
        // set the logfile scope
        parent::Logger( "manage_servers" );

        $this->m_oServerDataManager = new ServerDataManager(new WMSDatabase($szServerDataPath));

        $this->m_szWMSParseFile = $szWMSParseFile;
        $this->m_szServerDataPath = $szServerDataPath;

        /* ============================================================================
         * Initialize the status string
         * ========================================================================= */
        $this->m_szStatus = "";
        $this->m_bStatus = true;
    }

    function add($szURL, $szName, $nMaxId, $szComment)
    {
        // log event
        $this->log( LOG_QUIET, "Adding new server to database" );

        //pre-process the name to remove any WMS stuff from it

        $aszKeywords = array( "WMTVER", "VERSION", "REQUEST", "BBOX", "LAYERS",
                              "SRS", "WIDTH", "HEIGHT", "FORMAT", "QUERY_LAYERS",
                              "INFO_FORMAT" );

        $aszURL = explode( "?", $szURL );

        if ( count($aszURL) > 1 )
        {
            $szRemoved = "WARNING: The following parameters should not be ".
            "included in the URL:\n";

            parse_str( $aszURL[1], $aszURLParams );
            $aszURL[1] = "";
            $szAmp = "";
            $bInvalid = false;

            foreach ($aszURLParams as $szKey => $szValue)
            {
                if ( in_array( trim(strtoupper($szKey)), $aszKeywords) )
                {
                    $szRemoved .= " * ".$szKey." => ".$szValue."\n";
                    $bInvalid = true;
                    $this->m_bStatus = false;
                }
            }

            if ( $bInvalid )
            {
                $szRemoved .= "Leaving these parameters will likely ".
                "cause errors when trying to view ".
                "layers from this server.\n";
                $this->m_szStatus .= $szRemoved;
                //uncomment this line to remove the parameters
                //$http_form_vars['szURL'] = $aszURL[0]."?".$aszURL[1];
            }
        }

        // add the server record to the database
        $this->m_szStatus .= "Adding server [$szName] to list....";

        $nServer = $this->m_oServerDataManager->addServer( $nMaxId, $szName, $szURL, $szComment );

        if ( $nServer == false )
        {
            // log failure
            $this->m_szStatus .= "Failed\n";
            $this->m_bStatus = false;
        }
        else
        {
            // log success
            $this->m_szStatus .= "OK\n";

            $this->m_szStatus .= "Testing server [$szName]....";

            if ( ! $this->m_oServerDataManager->testServer( $nServer ) )
            {
                // log failure
                $this->m_szStatus .= "Not Available\n";
                $this->m_bStatus = false;
                $this->m_szStatus .= "Disconnecting server [$szName]....";
                if ( ! $this->m_oServerDataManager->setServerStatus( $nServer, 0 ) )
                {
                    // log failure
                    $this->m_szStatus .= "Failed\n";
                }
                else
                {
                    // log success
                    $this->m_szStatus .= "OK\n";
                }
            }
            else
            {
                // log success
                $this->m_szStatus .= "OK\n";

                // refresh the server right away
                $this->m_szStatus .= "Refreshing server [$szName]....";
                if ( ! $this->m_oServerDataManager->refreshServer( $nServer, $this->m_szServerDataPath,
                                     $this->m_szWMSParseFile ) )
                {
                    // log failure
                    $this->m_szStatus .= "Failed\n";
                    $this->m_bStatus = false;
                }
                else
                {
                    // log success
                    $this->m_szStatus .= "OK\n";
                }
            }
        }
    }


    function update($szName, $szURL, $szServerId, $szComment)
    {
        // log event
        $this->log( LOG_QUIET, "Updating server in database" );


        //pre-process the name to remove any WMS stuff from it

        $aszKeywords = array( "WMTVER", "VERSION", "REQUEST", "BBOX", "LAYERS",
                              "SRS", "WIDTH", "HEIGHT", "FORMAT", "QUERY_LAYERS",
                              "INFO_FORMAT" );

        $aszURL = explode( "?", $szURL );

        if ( count($aszURL) > 1 )
        {
            $szRemoved = "WARNING: The following parameters should not be ".
            "included in the URL:\n";

            parse_str( $aszURL[1], $aszURLParams );
            $aszURL[1] = "";
            $szAmp = "";
            $bInvalid = false;

            foreach ($aszURLParams as $szKey => $szValue)
            {
                if ( !in_array( trim(strtoupper($szKey)), $aszKeywords) )
                {
                    $aszURL[1] = $szAmp.$szKey."=".$szValue;
                    $szAmp = "&";
                }
                else
                {
                    $szRemoved .= " * ".$szKey." => ".$szValue."\n";
                    $bInvalid = true;
                    $this->m_bStatus = false;
                }
            }

            if ( $bInvalid )
            {
                $szRemoved .= "Leaving these parameters will likely ".
                "cause errors when trying to view ".
                "layers from this server.\n";
                $this->m_szStatus .= $szRemoved;
                //uncomment this line to remove the parameters
                //$http_form_vars['szURL'] = $aszURL[0]."?".$aszURL[1];
            }
        }

        // add the server record to the database
        $this->m_szStatus .= "Updating existing server [$szName]....";

        if ( ! $this->m_oServerDataManager->updateServer( $szServerId,
                            $szName, $szURL,
                            $szComment ) )
        {
            // log failure
            $this->m_szStatus .= "Failed\n";
        }
        else
        {
            // log success
            $this->m_szStatus .= "OK\n";
        }

        if (!$bInvalid )
        {
            // refresh the server right away
            $this->m_szStatus .= "Refreshing server [$szName]....";
            if ( ! $this->m_oServerDataManager->refreshServer( $szServerId, $this->m_szServerDataPath,
                                 $this->m_szWMSParseFile ) )
            {
                // log failure
                $this->m_szStatus .= "Failed\n";
                $this->m_bStatus = false;
            }
            else
            {
                // log success
                $this->m_szStatus .= "OK\n";
            }
        }
    }


    function connect($szSelectedServers, $http_form_vars)
    {
        if ( strlen( trim( $szSelectedServers ) ) > 0 )
        {
            // log event
            $this->log( LOG_QUIET, "Connecting server(s)..." );

            // connect all selected servers
            $anServers = explode( ",", $szSelectedServers );

            // loop to connect all
            foreach ( $anServers as $nServer )
            {
                $this->m_szStatus .= "Testing server [".$http_form_vars["sz".$nServer.
                                                                 "Name"]."]....";

                if ( !$this->m_oServerDataManager->testServer( $nServer ) )
                {
                    // log failure
                    $this->m_szStatus .= "Not Available\n";
                    $this->m_bStatus = false;
                    $this->m_szStatus .= "Disconnecting server [".$http_form_vars["sz".$nServer.
                                                                           "Name"]."]....";
                    if ( ! $this->m_oServerDataManager->setServerStatus( $nServer, 0 ) )
                    {
                        // log failure
                        $this->m_szStatus .= "Failed\n";
                    }
                    else
                    {
                        // log success
                        $this->m_szStatus .= "OK\n";
                    }
                }
                else
                {
                    // log success
                    $this->m_szStatus .= "OK\n";

                    // connect server
                    $this->m_szStatus .= "Connecting server [".$http_form_vars["sz".$nServer.
                                                                        "Name"]."]....";
                    if ( ! $this->m_oServerDataManager->setServerStatus( $nServer, 1 ) )
                    {
                        // log failure
                        $this->m_szStatus .= "Failed\n";
                    }
                    else
                    {
                        // log success
                        $this->m_szStatus .= "OK\n";
                    }
                }
            }
        }
        else
        {
            // nothing selected so give message
            $this->m_szStatus .= "Connecting server....cancelled [no server selected]\n";
        }
    }


    function disconnect($szSelectedServers, $http_form_vars)
    {
        if ( strlen( trim( $szSelectedServers ) ) > 0 )
        {
            // log event
            $this->log( LOG_QUIET, "Disconnecting server(s)..." );

            // connect all selected servers
            $anServers = explode( ",", $szSelectedServers );

            // loop to disconnect all
            foreach ( $anServers as $nServer )
            {
                // disconnect server
                $this->m_szStatus .= "Disconnecting server [".$http_form_vars["sz".$nServer.
                                                                       "Name"]."]....";
                if ( ! $this->m_oServerDataManager->setServerStatus( $nServer, 0 ) )
                {
                    // log failure
                    $this->m_szStatus .= "Failed\n";
                }
                else
                {
                    // log success
                    $this->m_szStatus .= "OK\n";
                }
            }
        }
        else
        {
            // nothing selected so give message
            $this->m_szStatus .= "Disconnecting server....cancelled [no server selected]\n";
        }
    }


    function remove($szSelectedServers, $http_form_vars)
    {
        if ( strlen( trim( $szSelectedServers ) ) > 0 )
        {
            // log event
            $this->log( LOG_QUIET, "Removing server(s)..." );

            // remove all selected servers
            $anServers = explode( ",", $szSelectedServers );

            // loop to remove all
            foreach ( $anServers as $nServer )
            {
                // remove server
                $this->m_szStatus .= "Removing server [".$http_form_vars["sz".$nServer.
                                                                  "Name"]."]....";
                if ( ! $this->m_oServerDataManager->removeServer( $nServer, $this->m_szServerDataPath ) )
                {
                    // log failure
                    $this->m_szStatus .= "Failed\n";
                }
                else
                {
                    // log success
                    $this->m_szStatus .= "OK\n";
                }
            }
        }
        else
        {
            // nothing selected so give message
            $this->m_szStatus .= "Removing server....cancelled [no server selected]\n";
        }
    }


    function refresh($szSelectedServers, $http_form_vars)
    {
        if ( strlen( trim( $szSelectedServers ) ) > 0 )
        {
            // log event
            $this->log( LOG_QUIET, "Refreshing server(s)..." );

            // refresh all selected servers
            $anServers = explode( ",", $szSelectedServers );

            // loop to refresh all
            foreach ( $anServers as $nServer )
            {
                // remove server
                $this->m_szStatus .= "Refreshing server [".$http_form_vars["sz".$nServer.
                                                                          "Name"]."]....";
                if ( ! $this->m_oServerDataManager->refreshServer( $nServer, 
                                                                   $this->m_szServerDataPath,
                                                                   $this->m_szWMSParseFile ) )
                {
                    // log failure
                    $this->m_szStatus .= "Failed\n";
                }
                else
                {
                    // log success
                    $this->m_szStatus .= "OK\n";
                }
            }
        }
        else
        {
            // nothing selected so give message
            $this->m_szStatus .= "Refresh server....cancelled [no server selected]\n";
        }
    }


    function test($szSelectedServers, $http_form_vars)
    {
        if ( strlen( trim( $szSelectedServers ) ) > 0 )
        {
            // log event
            $this->log( LOG_QUIET, "Testing server(s)..." );

            // refresh all selected servers
            $anServers = explode( ",", $szSelectedServers );

            // loop to refresh all
            foreach ( $anServers as $nServer )
            {
                // remove server
                $this->m_szStatus .= "Testing server [".$http_form_vars["sz".$nServer.
                                                                 "Name"]."]....";
                if ( ! $this->m_oServerDataManager->testServer( $nServer ) )
                {
                    // log failure
                    $this->m_szStatus .= "Not Available\n";
                }
                else
                {
                    // log success
                    $this->m_szStatus .= "OK\n";
                }
            }
        }
        else
        {
            // nothing selected so give message
            $this->m_szStatus .= "Refresh server....cancelled [no server selected]\n";
        }
    }
}
?>
