<?php
/**
 * GMapServer   Class definition for GMap popplace server search service
 *
 * @project     PHPGeoCoder
 * @revision    $Id:
 * @purpose     Class definition for gmap popplace search service.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * Check for a defined COMMON variable containing the absolute path.  If not 
 * found then check ../ then ./ else failure.
 */
if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON ) - 1, 1 ) == "/" )
    {
        include_once( COMMON."phpgeocoder/dbf_service.php");
    }
    else
    {
        include_once( COMMON."/phpgeocoder/dbf_service.php");
    }
}
elseif (file_exists("../dbf_service.php"))
{
    include_once("../dbf_service.php");
}
else
{
    include_once("./dbf_service.php");
}

class GMapServer extends DBFService
{
    var $nSearchPlaceNameMin = 70;

    function GMapServer($oGeoCoder, $szPopPlacePath)
    {
        if ($szPopPlacePath != "" && substr($szPopPlacePath, -1) != "/")
            $szPopPlacePath .= "/";

        if ($szPopPlacePath != "" && (!is_dir($szPopPlacePath) || 
            !is_file($szPopPlacePath."popplace.dbf")))
        {
            $this->error(ERR_WARNING, "PopPlacePath (".$szPopPlacePath.
                                      "popplace.dbf) is invalid or no
                                        popplace.dbf file. Using local one.");
            $szPopPlacePath = "";
        }

        parent::DBFService("GMAP_SERVER", $oGeoCoder, 
                           $szPopPlacePath."./popplace.dbf");
    }

    function search()
    {
        global $aszCanadianProvince;
 
        $nProv = 0;         // Province number
        $szPlaceName = "";  // Placename to search
        $bCanGo = false;    // True if mandatory parameter are there
        $bPerfect = false;  // True if a perfect match occure 

        // Scan all attributes
        foreach ($this->oGeoCoder->aoSearchAttribute as $oAttribute)
        {
            if ($oAttribute->getName() == "STATE_PROVINCE")
            {
                $nProv = $aszCanadianProvince[$oAttribute->getValue()];
            }

            // Placename is mandatory
            if ($oAttribute->getName() == "PLACE_NAME")
            {
                $szPlaceName = strtoupper($oAttribute->getValue());
                $bCanGo = true;
            }
        }

        // Is all mandatory params are sets ?
        if (!$bCanGo)
            return false;

        if (!parent::search())
            return false;

        // Get num records
        $nRecord = dbase_numrecords($this->oDBFConnection);

        // Scan all records
        for ($i=1; $i <= $nRecord; $i++)
        {
            $aszRecord = dbase_get_record($this->oDBFConnection, $i);

            // If place name contain two possible values (english and french)
            // compare both values.
            if (chop($aszRecord[6]) != "" && chop($aszRecord[7]) != "")
            {
                // This return a score from 0 to 100 for similar text
                similar_text(strtoupper(chop($aszRecord[6])), $szPlaceName, $nScore1);
                similar_text(strtoupper(chop($aszRecord[7])), $szPlaceName, $nScore2);

                $nScore = ($nScore1 > $nScore2) ? $nScore1 : $nScore2;
            }
            else
            {
                // This return a score from 0 to 100 for similar text
                similar_text(strtoupper(chop($aszRecord[5])), $szPlaceName, $nScore);
            }

            // If province is set it must match. If not just compare placename
            if (($nProv != 0 && $nProv == $aszRecord[10] && $nScore >= $this->nSearchPlaceNameMin) ||
                ($nProv == 0 && $nScore >= $this->nSearchPlaceNameMin))
            {
                $this->bFound = true;

                $oResult = new Result();
                $oResult->addAttribute(new PlaceName(chop($aszRecord[5])));
                $oResult->addAttribute(new StateProvince(chop($aszRecord[10])));
                $oResult->addAttribute(new LatLong($this->toDecimalDegree(chop($aszRecord[13]))*-1, 
                                                   $this->toDecimalDegree(chop($aszRecord[12]))));

                // If perfect match, delete all other matchs
                if ($nScore == 100)
                {
                    $bPerfect = true;
                    $this->aoResult = array();
                    array_push($this->aoResult, $oResult);
                }

                if (!$bPerfect)
                    array_push($this->aoResult, $oResult);
            }
        }
        return true;
    }


    /**
       toDecimalDegree takes DMS value (DD[D]MMSS)
       and return it in decimal degrees.
    */
    function toDecimalDegree($szDMS)
    {
        // Get two last caracters for seconds
        $nSecond = intval(substr($szDMS, -2));

        $szDMS = substr($szDMS, 0, -2);

        // Get two last caracters for minutes
        $nMinutes = intval(substr($szDMS, -2));

        $szDMS = substr($szDMS, 0, -2);

        // Get remaining caracters for degree
        $nDegree = intval($szDMS);

        return $nDegree + ($nMinutes/60) + ($nSeconds/3600);
    }
}
?>
