<?php
/**
 * GazeteerService   Class definition for Gazeteer search service
 *
 * @project     PHPGeoCoder
 * @revision    $Id:
 * @purpose     Class definition of Gazeteer search service.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * Check for a defined COMMON variable containing the absolute path.  If not 
 * found then check ../ then ./ else failure.
 */
if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON ) - 1, 1 ) == "/" )
        include_once( COMMON."phpgeocoder/web_service.php");
    else
        include_once( COMMON."/phpgeocoder/web_service.php");
}
elseif (file_exists("../web_service.php"))
{
    include_once("../web_service.php");
}
else
{
    include_once("./web_service.php");
} 

class GazeteerServer extends WebSearchService
{
    var $nIndex;

    function GazeteerServer($oGeoCoder="")
    {
        parent::WebSearchService("GAZETTEER_SERVER", $oGeoCoder, "http://cgdi-dev.geoconnections.org/cgi-bin/prototypes/cgdigaz/cgdigaz.cgi");

        $this->nIndex = 0;
    }

    function search()
    {
        global $aszCanadianProvince;

        $this->szParameters = "version=1.0&request=GetPlacenameGeometry&wildcards=true&";

        foreach ($this->oGeoCoder->aoSearchAttribute as $oAttribute)
        {
            if ($oAttribute->getName() == "PLACE_NAME")
            {
                $this->szParameters .= "placename=".urlencode($oAttribute->getValue())."&";

                $bFound = true;
            }
            else
            if ($oAttribute->getName() == "STATE_PROVINCE")
            {
                $this->szParameters .= "provterr=".urlencode($aszCanadianProvince[$oAttribute->getValue()])."&";

                $bFound = true;
            }
        }

        if (parent::search())
        {
            // Parse respond
            $xml_parser = xml_parser_create();
            xml_set_object($xml_parser, $this);
            xml_set_character_data_handler($xml_parser, "characterData");
            xml_set_element_handler($xml_parser, "startElement", "endElement");

            if (!xml_parse($xml_parser, $this->szRawResult)) 
            {
                die(sprintf("XML error: %s at line %d",
                xml_error_string(xml_get_error_code($xml_parser)),
                xml_get_current_line_number($xml_parser)));
            }

            xml_parser_free($xml_parser);
        }
    }

    function characterData($oParser, $szData) 
    {
        $this->szLastValue = utf8_decode($szData);
    }

    function startElement($oParser, $szName, $szAttrs) 
    {
        if ($szName == "GAZETTEERENTRY")
        {
            $this->bFound = true;
            $oRes = new Result();
            array_push($this->aoResult, $oRes); 
            $this->nIndex = count($this->aoResult) - 1;
        }
    }

    function endElement($oParser, $szName) 
    {
        if ($szName == "GAZETTEERENTRY")
            $this->bFound = false;

        if ($szName == "FEATURE_NA" && $this->bFound)
            $this->aoResult[$this->nIndex]->addAttribute(new PlaceName($this->szLastValue));

        if ($szName == "ENTITY" && $this->bFound)
            $this->aoResult[$this->nIndex]->addAttribute(new Entity($this->szLastValue));

        if ($szName == "LOCATION1" && $this->bFound)
            $this->aoResult[$this->nIndex]->addAttribute(new StateProvince($this->szLastValue));

        if ($szName == "GML:COORDINATES" && $this->bFound)
        {
            $aszLatLong = explode(",", $this->szLastValue);
            $this->aoResult[$this->nIndex]->addAttribute(new LatLong($aszLatLong[0], $aszLatLong[1]));
        }
    }
}
?>
