<?php
/**
 * Service      Abstract class definition
 *
 * @project     PHPGeoCoder
 * @revision    $Id:
 * @purpose     Abstract class definition of service.
 * @author      Sacha Fournier (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/**
 * Check for a defined COMMON variable containing the absolute path.  If not 
 * found then check ../ then ./ else failure.
 */
if ( defined( "COMMON" ) && is_dir( COMMON ) )
{
    // check for closing "\" or "/"
    if ( substr( COMMON, strlen( COMMON )- 1, 1 ) == "\\" ||
         substr( COMMON, strlen( COMMON ) - 1, 1 ) == "/" )
        include_once( COMMON."logger/logger.php");
    else
        include_once( COMMON."/logger/logger.php");
}
elseif (file_exists("../logger/logger.php"))
{
    include_once("../logger/logger.php");
}
else
{
    include_once("./logger/logger.php");
} 

include_once("attribute.php");
include_once("result.php");

class SearchService extends Logger
{
    var $szName;     // Search engine name
    var $oGeoCoder;  // Pointer to main geocoder object

    var $aoResult;   // Array of result object

    function SearchService($szSearchServiceName = "", $oGeoCoder = "")
    {
        parent::Logger("Service");
        $this->log(LOG_VERBOSE, "SearchService($szSearchServiceName, $oGeoCoder)");

        $this->szName = $szSearchServiceName;
        $this->oGeoCoder = $oGeoCoder;

        $this->aoResult = array();
    }

    function reset()
    {
        $this->aoResult = array();
    }

    function search()
    {
    }
}

?>
