<?php
include_once("geocoder.php");
include_once("../logger/logfile.php");
include_once("../logger/error_manager.php");

// List of search service to use
include_once("./services/postalcode_server.php");
include_once("./services/gazetteer_server.php");
include_once("./services/gmap_server.php");

include_once("attribute.php");

$gLogFile = new LogFile("./example.log", LOG_TO_FILE, true);
$gLogFile->setMaxLogLevel(LOG_ALL);

$gErrorManager = new ErrorManager();

$oGeoCoder = new PHPGeoCoder();

$oGeoCoder->addSearchAttribute(new PlaceName("Kangiqsualujjuaq"));
$oGeoCoder->addSearchAttribute(new StateProvince("Quebec"));

//$oGeoCoder->addSearchService(new PostalCodeServer($oGeoCoder)) ;
$oGeoCoder->addSearchService(new GazeteerServer($oGeoCoder)) ;
$oGeoCoder->addSearchService(new GMapServer($oGeoCoder)) ;

$oGeoCoder->searchServices("GMAP_SERVER");

$aoResult = $oGeoCoder->getResult();
foreach($aoResult as $oResult)
    foreach($oResult->aoAttribute as $oAttribute)
        echo $oAttribute->getName()." ".$oAttribute->getValue()."\n";
?>
