<?php
/******************************************************************************
 * $Id:
 *
 * Project:  PHP Interface for OGR C API
 * Purpose:  Test program for PHP/OGR module.
 * Author:   Normand Savard, nsavard@dmsolutions.ca
 * Changes:  William A. Bronsema, C.E.T. 
 *           28-10-2003
 *           - ported to php_utils
 *
 ******************************************************************************
 * Copyright (c) 2003, DM Solutions Group Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *****************************************************************************/
function ogr2ogr( $szSourceFile, $szDestinationPath, $szOutputFormat )
{
    // determine module
    if ( PHP_OS == "WINNT" || PHP_OS == "WIN32" )
        $szOGRModule = "php_ogr.dll";
    else
        $szOGRModule = "php_ogr.so";
        
    // ensure that the php_ogr module is loaded
    if( !extension_loaded( 'ogr' ) ) dl( $szOGRModule );
    
/* -------------------------------------------------------------------- */
/*      Register format(s).                                             */
/* -------------------------------------------------------------------- */
    OGRRegisterAll();

/* -------------------------------------------------------------------- */
/*      Open data source.                                               */
/* -------------------------------------------------------------------- */
    $hSFDriver = NULL;
    $hDS = @OGROpen( $szSourceFile, FALSE, $hSFDriver );

/* -------------------------------------------------------------------- */
/*      Return failure                                                  */
/* -------------------------------------------------------------------- */
    if( $hDS == NULL )
        return false;

/* -------------------------------------------------------------------- */
/*      Find the output driver.                                         */
/* -------------------------------------------------------------------- */
    for( $iDriver = 0;
         $iDriver < OGRGetDriverCount() && $hSFDriver == NULL;
         $iDriver++ )
    {
        if( !strcasecmp(OGR_DR_GetName(OGRGetDriver($iDriver)) , $szOutputFormat) )
        {
            $hSFDriver = OGRGetDriver($iDriver);
        }
    }
    
    // check for failure
    if( $hSFDriver == NULL )
        return false;

    // test compatability
    if( !OGR_Dr_TestCapability( $hSFDriver, ODrCCreateDataSource ) )
        return false;

/* -------------------------------------------------------------------- */
/*      Create the output data source.                                  */
/* -------------------------------------------------------------------- */
   $hODS = OGR_Dr_CreateDataSource( $hSFDriver, $szDestinationPath, NULL);
 
    if( $hODS == NULL )
        return false;
/* -------------------------------------------------------------------- */
/*      Process each data source layer.                                 */
/* -------------------------------------------------------------------- */
    $astrLayers = array();
    for( $iLayer = 0; $iLayer < OGR_DS_GetLayerCount($hDS); $iLayer++ )
    {
        $hLayer = OGR_DS_GetLayer($hDS, $iLayer);

        if( $hLayer == NULL )
            return false;

        if( count($astrLayers) == 0 || 
            in_array(OGR_FD_GetName(OGR_L_GetLayerDefn($hLayer)), 
                                        $astrLayers) != FALSE )
        {
            if( !translateLayer( $hDS, $hLayer, $hODS ) )
                return false;
        }
    }

/* -------------------------------------------------------------------- */
/*      Close down.                                                     */
/* -------------------------------------------------------------------- */
    OGR_DS_Destroy($hDS);
    OGR_DS_Destroy($hODS);
    
    return true;


}


function translateLayer( $hSrcDS, $hSrcLayer, $hDstDS )
{

/* -------------------------------------------------------------------- */
/*      Create the layer.                                               */
/* -------------------------------------------------------------------- */
    if( !OGR_DS_TestCapability( $hDstDS, ODsCCreateLayer ) )
        return false;

    $hFDefn = OGR_L_GetLayerDefn($hSrcLayer);


    $hDstLayer = OGR_DS_CreateLayer( $hDstDS, OGR_FD_GetName($hFDefn),
                                     OGR_L_GetSpatialRef($hSrcLayer), 
                                     OGR_FD_GetGeomType($hFDefn),NULL );
    if( $hDstLayer == NULL )
        return FALSE;

/* -------------------------------------------------------------------- */
/*      Add fields.                                                     */
/* -------------------------------------------------------------------- */
    for( $iField = 0; $iField < OGR_FD_GetFieldCount($hFDefn); $iField++ )
    {
        if( OGR_L_CreateField( $hDstLayer, OGR_FD_GetFieldDefn( $hFDefn, $iField),
                          0 /*bApproOK*/ ) != OGRERR_NONE )
            return FALSE;
    }
/* -------------------------------------------------------------------- */
/*      Transfer features.                                              */
/* -------------------------------------------------------------------- */
    OGR_L_ResetReading($hSrcLayer);

    while( ($hFeature = OGR_L_GetNextFeature($hSrcLayer)) != NULL )
    {

        $hDstFeature = OGR_F_Create( OGR_L_GetLayerDefn($hDstLayer) );

        if( OGR_F_SetFrom( $hDstFeature, $hFeature, FALSE /*bForgiving*/ ) 
            != OGRERR_NONE )
        {
            OGR_F_Destroy($hFeature);
            return false;
        }
        
        OGR_F_Destroy($hFeature);
        
        if( OGR_L_CreateFeature( $hDstLayer, $hDstFeature ) != OGRERR_NONE )
        {
            OGR_F_Destroy($hDstFeature);
            return FALSE;
        }

        OGR_F_Destroy($hDstFeature);
    }
    return true;
}
?>