<?php

define( "LOGGER_PATH", "../../logger/" );
define( "LOG_FILE", "d:/junk/test.log" );

include_once( LOGGER_PATH."logfile.php" );
include_once( LOGGER_PATH."error_manager.php" );
include_once( LOGGER_PATH."logger.php" );
include_once( "../mlt.php" );

// create new logfile object (customize parameters)
$oLogFile = new LogFile(LOG_FILE, LOG_TO_FILE, 1);

// set the max log level (adjust as necessary)
$oLogFile->setMaxLogLevel( LOG_ALL );

// create new error manager object
$oErrorManager = new ErrorManager();

// create a new MLT object
$oMLT = new MLTdBase( "english" );
$oMLT->setLogFile( $oLogFile );
$oMLT->setErrorManager( $oErrorManager );

// build list of languages to load
$aszLang[0] = "english";
$aszLang[1] = "french";

// load the resourcre file into memory
//$oMLT->loadResource( "../resource.dbf" );
$oMLT->loadResource( "../resource.dbf",$aszLang );

// get resources
echo "Resource 1 (in english) = ".$oMLT->get(1, "default")."<BR>";
//echo "Resource 2 (in french) = ".$oMLT->get(2, "default")."<BR>";
//echo "Did not translate because only loaded english.<BR>";
$oMLT->setLanguage("french");
//$oMLT->loadResource( "../resource.dbf", "french" );
echo "Resource 2 (in french) = ".$oMLT->get(2, "default")."<BR>";
echo "Resource 22 (in french - does not exist) = ".$oMLT->get(22, "default")."<BR>";

// set up parameters for the vsprintf test (omly works for php4.1+
$aParams[0] = 2;
$aParams[1] = "cage";
//echo "Resource 16 (vsprintf test) = ".$oMLT->get(16, "default", $aParams)."<BR>";

// give message that something happened
echo "Process complete. ".date("[D.M.d.Y.G:i:s]");

?>