<?php
/**
 * Global Preferences
 * 
 * @project     PHP Utilities
 * @revision    $Id: globprefs.php,v 1.2 2002/03/07 03:31:30 bronsema Exp $
 * @purpose     This file contains the global setting required for the Edit
 *              Resources application.
 * @author      William A. Bronsema, C.E.T. (bronsema@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2001, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

/*****************************************************************************
 * $Log: globprefs.php,v $
 * Revision 1.2  2002/03/07 03:31:30  bronsema
 * Finished construction.
 *
 * Revision 1.1  2002/03/06 16:38:52  bronsema
 * Initial creation
 *
 *****************************************************************************/

// set local paths 
define( "LOGGER_PATH", "../../logger/" );
define( "LOG_FILE", "./edit_resources.log" );
define( "RESOURCE_FILE", "./resource.dbf");

// include the necessry classes
include_once( LOGGER_PATH."logfile.php" );
include_once( LOGGER_PATH."error_manager.php" );
include_once( LOGGER_PATH."logger.php" );
include_once( "../mlt.php" );

// include the navigation tool to display records
include_once( "./dbf_nav.php" );

// create new logfile object
$oLogFile = new LogFile(LOG_FILE, LOG_TO_FILE, 1);

// set the max log level (adjust as necessary)
$oLogFile->setMaxLogLevel( LOG_ALL );

// create new error manager object
$oErrorManager = new ErrorManager();

// create a new logger object
$oMLT = new MLT( ENGLISH, RESOURCE_FILE );

// set logfile and error manager
$oMLT->setLogFile( $oLogFile );
$oMLT->setErrorManager( $oErrorManager );

?>