<?php
/**
 * PHP-Utils
 *
 * @project     PHP-Utils
 * @revision    $Id: jtree.php,v 1.2 2003/02/26 20:21:02 bronsema Exp $
 * @purpose     Supporting php functions.
 * @author      William A. Bronsema, C.E.T. (dev@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 **/

/* ============================================================================
 * Build an array with the HTTP GET or POST parameters.
 * ========================================================================= */
$http_form_vars = (count($_POST) > 0) ?
                  $_POST : ((count($_GET) > 0) ? $_GET : array() );
/*
// debug
foreach($http_form_vars as $key=>$value  )   
    echo "$key=>$value<br>";
*/    

/* ============================================================================
 * Validate inputs
 * ========================================================================= */
// check for mapfile in the session
if ( isset( $_SESSION["mapfile"] ) && strlen( $_SESSION["mapfile"] ) > 0 &&
     !isset( $http_form_vars["mapfile"] ) )
    $http_form_vars["mapfile"] = $_SESSION["mapfile"];
    
// check for output file in session
if ( isset( $_SESSION["treeSourceFile"] ) && 
     strlen( $_SESSION["treeSourceFile"] ) > 0 &&
     !isset( $http_form_vars["treeSourceFile"] ) )
    $http_form_vars["treeSourceFile"] = $_SESSION["treeSourceFile"];
    
// check for output file in session
if ( isset( $_SESSION["metaGroupName"] ) && 
     strlen( $_SESSION["metaGroupName"] ) > 0 &&
     !isset( $http_form_vars["metaGroupName"] ) )
    $http_form_vars["metaGroupName"] = $_SESSION["metaGroupName"];    

// check for the default MetaName
if ( isset( $_SESSION["defaultMetaName"] ) && 
     strlen( $_SESSION["defaultMetaName"] ) > 0 &&
     !isset( $http_form_vars["defaultMetaName"] ) )
    $http_form_vars["defaultMetaName"] = $_SESSION["defaultMetaName"]; 

// check for the ignore metaname
if ( isset( $_SESSION["ignoreMetaName"] ) && 
     strlen( $_SESSION["ignoreMetaName"] ) > 0 &&
     !isset( $http_form_vars["ignoreMetaName"] ) )
    $http_form_vars["ignoreMetaName"] = $_SESSION["ignoreMetaName"]; 
    
// check for mapfile
if ( !isset( $http_form_vars["mapfile"] ) || 
                                    strlen( $http_form_vars["mapfile"] ) <= 0 )
    exit( "Error: Mapfile not specified for tree source." );

// check for optional output tree source file (default to current directory)
if ( !isset( $http_form_vars["treeSourceFile"] ) || 
                             strlen( $http_form_vars["treeSourceFile"] ) <= 0 )
    $http_form_vars["treeSourceFile"] = "./treeSource.js";
    
// check for metadata group name
if ( !isset( $http_form_vars["metaGroupName"] ) )
    $http_form_vars["metaGroupName"] = "";
    
/* ============================================================================
 * Build tree only on the first load or if overridden.
 * ========================================================================= */
if ( !isset( $http_form_vars["notFirstLoad"] ) || 
                                    isset( $http_form_vars["forceRebuild"] ) )
{
    // build tree and verify
    if ( !buildTreeSource( $http_form_vars["mapfile"], 
                           $http_form_vars["treeSourceFile"],
                           $http_form_vars["defaultMetaName"],
                           $http_form_vars["metaGroupName"],
                           $http_form_vars["ignoreMetaName"] ) )
        trigger_error( "Unable to build tree source file." );  // this need to be handled properly
}
                                    
                                                                       
/**
 * buildTreeSource()
 *
 * Postcondition:  This function builds a javascript tree source file based
 *                 on the given mapfile structure.
 * @param szMapFile string - Mapfile to read.
 * @param szOutputFile string - Path and filename of the output file.
 * @param szDefaultGroup string - The default group to use if metadata group 
 *                                is not set or if it is ignored.
 * @param szMetaGroupName string - Name of the metadata item to group by.
 * @param szIgnoreGroup string - Optional group name to treat as default.
 * @return boolean - True if successfull, false if not.
 
 * @desc Generates javascript tree source file based on given mapfile.
 */
function buildTreeSource( $szMapFile, $szOutputFile, $szDefaultGroup ,
                                    $szMetaGroupName = "", $szIgnoreGroup = "" )
{
    // intialize variables
    $aszTree = array();
    $aszOutput =  array();
    
    // open the mapfile
    $oMap = ms_newMapObj( $szMapFile );
    
    // loop through each layer
    for ( $i=0; $i<$oMap->numlayers; $i++ )
    {
        // get layer
        $oLayer = $oMap->getLayer( $i );

        // get meta-data grouping
        $szMetaGroup = $oLayer->getMetaData( $szMetaGroupName );
        
        // check if this is group to ignore (send to default)
        if ( $szMetaGroup == $szIgnoreGroup || strlen( $szMetaGroup ) <= 0  )
            $szMetaGroup = $szDefaultGroup;
            
        // skip if no meta group (i.e. default failed)
        if ( strlen( $szMetaGroup ) > 0 )
        {
            // get group
            $szGroup = $oLayer->group;
            if ( $szGroup == "" ) $szGroup = "NoGroup";
            
            // add layer index to array
            if ( !isset( $aszTree[$szMetaGroup][$szGroup] ) ||
                 !is_array( $aszTree[$szMetaGroup][$szGroup] ))
                $aszTree[$szMetaGroup][$szGroup] = array();
            array_push( $aszTree[$szMetaGroup][$szGroup], $i );
        }
        
    // end for loop
    }
    
    // begin the tree
    array_push( $aszOutput, "foldersTree = gFld(\"Layers\")" );
    
    // loop through the meta-group list array and build output array
    $i = 0;
    $j = 0;
    $k = 0;
    foreach( $aszTree as $key=>$szMetaGroup )
    {      
        // add main node for the meta data group
        array_push( $aszOutput, "main$i = insFld(foldersTree, gFld(\"$key\"))" );
        
        // loop through the group array
        foreach( $szMetaGroup as $Gkey=>$szGroup )
        {
            // add a sub branch for each group found (suppress "NoGroup")
            if ( $Gkey != "NoGroup" )
            {
                array_push( $aszOutput, "sub$j = insFld(main$i, gFld(\"$Gkey\"))" );
                array_push( $aszOutput, "sub$j.iconSrc = ICONPATH + \"tree_group.gif\"" );
                array_push( $aszOutput, "sub$j.iconSrcClosed = ICONPATH + \"tree_group.gif\"" );
            }
                    
            // add a node for each layer encountered
            foreach( $szGroup as $szLayer )
            {
                // get layer name from layer metadata
                $oLayer = $oMap->getLayer( $szLayer );
                $szLayerName = $oLayer->getMetaData( "LEGEND_TITLE" );
                if ( $szLayerName == "" ) $szLayerName = $oLayer->name;
                                
                // check for "NoGroup"
                if ( $Gkey != "NoGroup" )
                {
                    array_push( $aszOutput, "node$k = insDoc(sub$j, gLnk(\"S\", \"<a href=\\\"javascript:addLayer('$szLayer')\\\">$szLayerName</a>\"))" );
                }
                else
                {
                    //array_push( $aszOutput, "node$k = insDoc(main$i, gLnk(\"S\", \"<u>$szLayerName</u>\", \"javascript:addLayer('$szLayer')\"))" );
                    array_push( $aszOutput, "node$k = insDoc(main$i, gLnk(\"S\", \"<a href=\\\"javascript:addLayer('$szLayer')\\\">$szLayerName</a>\"))" );
                }
                // override the icon
                $szLayerType = $oLayer->getmetadata( "I3_LAYER_TYPE" );
                if ( $szLayerType == "AOI" )
                    $szLayerIcon = "node$k.iconSrc = ICONPATH + \"tree_layer_aoi.gif\"";
                elseif( $szLayerType == "REFERENCE" )
                    $szLayerIcon = "node$k.iconSrc = ICONPATH + \"a_pixel.gif\"";
                else
                    $szLayerIcon = "node$k.iconSrc = ICONPATH + \"tree_layer.gif\"";
                    
                array_push( $aszOutput, $szLayerIcon );
                
                // increment the counter
                $k++;
             
            // end layer for loop
            }
            
            // increment the counter
            $j++;
            
        // end group for loop
        }
        
        // increment counter
        $i++;
        
    // end meta data group for loop
    }
    
    // write the array to file
    if ( !writeArrayToFile( $szOutputFile, $aszOutput ) )
        return false;
        
    // return success
    return true;
}

/**
 * Postcondition:  This function writes the given array to the specify file one
 *                 element per line.
 * 
 * @param $szFile string - Path and filename of the file to write to.
 * @param $aszList array - Array to write out.
 * @return boolean - True if successful, false if not.
 *
 * @desc Write elements of an array to a file.
*/
function writeArrayToFile( $szFile, $aszList )
{
    // open the file, check for failure
    if ( !( $fp = fopen( $szFile, "w" ) ) ) return false;

    // loop through the array and write to file
    foreach ($aszList as $line) fputs( $fp, $line."\n" );

    // close the file
    fclose( $fp );

    // return success
    return true;
}
?>