<?php
/**
 * create a bunch of buttons, save them to a local diretory and also display them in a page.
 *
 * it is intended that you would make a copy of this file for a project.
 */

include_once( "buttonizer.php" );

DEFINE( "DEBUG", false ); //change this to true if you want to see the buttons being built :)
DEFINE( "BUTTON_DIRECTORY", "c:/tmp/ms_tmp/" ); //change this to the place to save the buttons
DEFINE( "BUTTON_URL", "/ms_tmp/" ); //change this to a URL that can view the BUTTON_DIRECTORY
//build parameters array
$aParams = array();

setParameter( $aParams, "width", 100 );
setParameter( $aParams, "height", 26 );
setParameter( $aParams, "backgroundcolor", "CCDDDD" );
setParameter( $aParams, "border_tl_image", "tl.png" );
setParameter( $aParams, "border_t_image", "t.png" );
setParameter( $aParams, "border_tr_image", "tr.png" );
setParameter( $aParams, "border_r_image", "r.png" );
setParameter( $aParams, "border_br_image", "br.png" );
setParameter( $aParams, "border_b_image", "b.png" );
setParameter( $aParams, "border_bl_image", "bl.png" );
setParameter( $aParams, "border_l_image", "l.png" );
setParameter( $aParams, "backgroundgraphic", "" );
setParameter( $aParams, "labelfont", "arialbd.ttf" );
setParameter( $aParams, "labelsize", "11" );
setParameter( $aParams, "labelcolor", "000000" );
setParameter( $aParams, "labelalign", "left" );
setParameter( $aParams, "padding", 2 );
setParameter( $aParams, "nudge", -1 );

/**
 * this should be all you need to copy to make multiple buttons.
 * If you need to change width, height etc, then just copy a line
 * from above.  Please note that changing a parameter means all
 * future buttons get that value until you change it again.
 */
makeButton( "button1.png", "test button", "", $aParams );

/* a second button using all the same parameters except graphic and label */
makeButton( "button2.png", "another button", "", $aParams );


function setParameter( &$aParams, $szName, $mDefault )
{
    $aParams[$szName] = $mDefault;
}

function makeButton( $buttonName, $buttonLabel, $buttonGraphic, $buttonParams )
{
    setParameter( $buttonParams, "label", $buttonLabel );
    setParameter( $buttonParams, "graphic", $buttonGraphic );
    buttonize( BUTTON_DIRECTORY.$buttonName, $buttonParams );
    echo "<img src=\"".BUTTON_URL.$buttonName."\" width=\"".
         $buttonParams["width"]."\" height=\"".$buttonParams["height"].
         "\" border=\"0\"><br>\n";
}
?>