<?php
/**
 *
 * @project     CWC2
 * @revision    $Id: HttpFormVars.php,v 1.15 2004/04/13 13:40:31 pspencer Exp $ 
 * @purpose     Manage form variables case-insensitively
 * @author      DM Solutions Group (sfournier@dmsolutions.ca)
 * @copyright
 * <b>Copyright (c) 2002, DM Solutions Group Inc.</b>
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
 /*
  * Intended to be passed one of $_GET or $_POST (or an merge of both) then
  * variables can be accessed case-insensitively by calling IsVarSet or GetVar\
  */
  
class HttpFormVars
{
    /**
     * @param maszVars Array of variables that can be accessed
     */
    var $maszVars = array();

    /**
     * Constructor takes an array of variables to be made available.
     */
    function HttpFormVars(&$aszVars)
    {
        if (is_array($aszVars))
        {
            if (function_exists( 'array_change_key_case' ))
            {
               $this->maszVars = array_change_key_case( $aszVars, CASE_UPPER );
            }
            else
            {
               foreach($aszVars as $key => $value)
               $this->maszVars[ strtoupper($key) ] = $value;
            }
        }
    }

    /**
     * Check if variable exist in array
     *
     * @param szVarName Variable name to check if exist
     * @param bCaseSens Make the test case sensitive (default false)
     *       this is now deprecated, all tests are case-insensitive
     *
     *@return TRUE if found
     */
    function isVarSet($szVarName, $bCaseSens=false)
    {
        return isset($this->maszVars[ strtoupper($szVarName) ]);
    }

    /**
     * Check if variable exist in array and return it
     *
     * @param szVarName Variable name to get value
     * @param bCaseSens Make the test case sensitive (default false)
     *        deprecated, all tests are now case-insensitive
     *
     * @return Value if found. FALSE if not found.
     */
    function getVar($szVarName, $bCaseSens=true)
    {
        $mResult = false;

        $szKey = strtoupper($szVarName);
        if (isset($this->maszVars[$szKey]))
            $mResult = $this->maszVars[$szKey];

        return $mResult;
    }

    /**
     * Set variable value
     *
     * @param szVarName Variable name to set
     * @param szValueToAssign Value to assign
     * @param bCaseSens Make the test case sensitive (default false)
     *        deprecated, all keys are now case-insensitive
     *
     *@return TRUE if is set properly.
     */
    function setVar($szVarName, $szValueToAssign, $bCaseSens=true)
    {
        $this->maszVars[strtoupper($szVarName)] = $szValueToAssign;
        return true;
    }

    /**
     * Add variable value
     * 
     * @param szVarName Variable name to add
     * @param szValueToAssign Value to assign (default "")
     * @return TRUE if is set properly.
     */
    function addVar($szVarName, $szValueToAssign="")
    {
        return $this->setVar( $szVarName, $szValueToAssign );
    }
}
?>